/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.security.SignatureException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AbstractAuthorizationGrant;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.CacheGrant;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.WebKeysConfiguration;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.ldap.PairwiseIdentifier;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.ldap.TokenType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.IdTokenFactory;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.model.token.JwtSigner;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.PairwiseIdentifierService;
import org.xdi.oxauth.util.TokenHashUtil;
import org.xdi.service.CacheService;
import org.xdi.util.security.StringEncrypter;

public class AuthorizationGrant
extends AbstractAuthorizationGrant {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationGrant.class);
    @Inject
    private CacheService cacheService;
    @Inject
    private GrantService grantService;
    @Inject
    private IdTokenFactory idTokenFactory;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private PairwiseIdentifierService pairwiseIdentifierService;
    @Inject
    private ClientService clientService;
    private boolean isCachedWithNoPersistence = false;
    private boolean isImplicitFlow = false;

    public AuthorizationGrant() {
    }

    public AuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super(user, authorizationGrantType, client, authenticationTime);
    }

    @Override
    public void init(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super.init(user, authorizationGrantType, client, authenticationTime);
    }

    public IdToken createIdToken(IAuthorizationGrant grant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        JsonWebResponse jwr = this.idTokenFactory.createJwr(grant, nonce, authorizationCode, accessToken, scopes, includeIdTokenClaims, preProcessing);
        return new IdToken(jwr.toString(), jwr.getClaims().getClaimAsDate("iat"), jwr.getClaims().getClaimAsDate("exp"));
    }

    @Override
    public String checkScopesPolicy(String scope) {
        String result = super.checkScopesPolicy(scope);
        this.save();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save() {
        if (this.isCachedWithNoPersistence) {
            if (this.getAuthorizationGrantType() != AuthorizationGrantType.AUTHORIZATION_CODE) throw new UnsupportedOperationException("Grant caching is not supported for : " + (Object)((Object)this.getAuthorizationGrantType()));
            this.saveInCache();
            return;
        } else {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getUseCacheForAllImplicitFlowObjects()) && this.isImplicitFlow()) {
                this.saveInCache();
                return;
            }
            this.saveImpl();
        }
    }

    private void saveInCache() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        this.cacheService.put(Integer.toString(cachedGrant.getExpiresIn()), cachedGrant.cacheKey(), (Object)cachedGrant);
    }

    public boolean isImplicitFlow() {
        return this.getAuthorizationGrantType() == null || this.getAuthorizationGrantType() == AuthorizationGrantType.IMPLICIT;
    }

    private void saveImpl() {
        List<TokenLdap> grants;
        String grantId = this.getGrantId();
        if (grantId != null && StringUtils.isNotBlank((String)grantId) && (grants = this.grantService.getGrantsByGrantId(grantId)) != null && !grants.isEmpty()) {
            String nonce = this.getNonce();
            String scopes = this.getScopesAsString();
            for (TokenLdap t : grants) {
                t.setNonce(nonce);
                t.setScope(scopes);
                t.setAuthMode(this.getAcrValues());
                t.setSessionDn(this.getSessionDn());
                t.setAuthenticationTime(this.getAuthenticationTime());
                t.setCodeChallenge(this.getCodeChallenge());
                t.setCodeChallengeMethod(this.getCodeChallengeMethod());
                t.setClaims(this.getClaims());
                JwtAuthorizationRequest jwtRequest = this.getJwtAuthorizationRequest();
                if (jwtRequest != null && StringUtils.isNotBlank((String)jwtRequest.getEncodedJwt())) {
                    t.setJwtRequest(jwtRequest.getEncodedJwt());
                }
                log.debug("Saving grant: " + grantId + ", code_challenge: " + this.getCodeChallenge());
                this.grantService.mergeSilently(t);
            }
        }
    }

    @Override
    public AccessToken createAccessToken() {
        try {
            AccessToken accessToken = super.createAccessToken();
            if (this.getClient().isAccessTokenAsJwt()) {
                accessToken.setCode(this.createAccessTokenAsJwt(accessToken));
            }
            if (accessToken.getExpiresIn() > 0) {
                this.persist(this.asToken(accessToken));
            }
            return accessToken;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String createAccessTokenAsJwt(AccessToken accessToken) throws Exception {
        User user = this.getUser();
        Client client = this.getClient();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAccessTokenSigningAlg() != null && SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg()) != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg());
        }
        JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
        Jwt jwt = jwtSigner.newJwt();
        jwt.getClaims().setClaim("scope", (List)Lists.newArrayList(this.getScopes()));
        jwt.getClaims().setClaim("client_id", this.getClientId());
        jwt.getClaims().setClaim("username", user != null ? user.getAttribute("displayName") : null);
        jwt.getClaims().setClaim("token_type", accessToken.getTokenType().getName());
        jwt.getClaims().setExpirationTime(accessToken.getExpirationDate());
        jwt.getClaims().setIssuedAt(accessToken.getCreationDate());
        jwt.getClaims().setAudience(this.getClientId());
        jwt.getClaims().setSubjectIdentifier(this.getSub());
        return jwtSigner.sign().toString();
    }

    @Override
    public RefreshToken createRefreshToken() {
        try {
            RefreshToken refreshToken = super.createRefreshToken();
            if (refreshToken.getExpiresIn() > 0) {
                this.persist(this.asToken(refreshToken));
            }
            return refreshToken;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IdToken createIdToken(String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, AuthorizationGrant authorizationGrant, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws SignatureException, StringEncrypter.EncryptionException, InvalidJwtException, InvalidJweException {
        try {
            IdToken idToken = this.createIdToken(this, nonce, authorizationCode, accessToken, this.getScopes(), includeIdTokenClaims, preProcessing);
            String acrValues = authorizationGrant.getAcrValues();
            String sessionDn = authorizationGrant.getSessionDn();
            if (idToken.getExpiresIn() > 0) {
                TokenLdap tokenLdap = this.asToken(idToken);
                tokenLdap.setAuthMode(acrValues);
                tokenLdap.setSessionDn(sessionDn);
                this.persist(tokenLdap);
            }
            this.setAcrValues(acrValues);
            this.setSessionDn(sessionDn);
            this.save();
            return idToken;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void persist(TokenLdap p_token) {
        this.grantService.persist(p_token);
    }

    public void persist(AuthorizationCode p_code) {
        this.persist(this.asToken(p_code));
    }

    public TokenLdap asToken(IdToken p_token) {
        TokenLdap result = this.asTokenLdap(p_token);
        result.setTokenTypeEnum(TokenType.ID_TOKEN);
        return result;
    }

    public TokenLdap asToken(RefreshToken p_token) {
        TokenLdap result = this.asTokenLdap(p_token);
        result.setTokenTypeEnum(TokenType.REFRESH_TOKEN);
        return result;
    }

    public TokenLdap asToken(AuthorizationCode p_authorizationCode) {
        TokenLdap result = this.asTokenLdap(p_authorizationCode);
        result.setTokenTypeEnum(TokenType.AUTHORIZATION_CODE);
        return result;
    }

    public TokenLdap asToken(AccessToken p_accessToken) {
        TokenLdap result = this.asTokenLdap(p_accessToken);
        result.setTokenTypeEnum(TokenType.ACCESS_TOKEN);
        return result;
    }

    public String getScopesAsString() {
        StringBuilder scopes = new StringBuilder();
        for (String s : this.getScopes()) {
            scopes.append(s).append(" ");
        }
        return scopes.toString().trim();
    }

    public TokenLdap asTokenLdap(AbstractToken p_token) {
        JwtAuthorizationRequest jwtRequest;
        String nonce;
        AuthorizationCode authorizationCode;
        String id = GrantService.generateGrantId();
        TokenLdap result = new TokenLdap();
        result.setDn(this.grantService.buildDn(id, this.getGrantId(), this.getClientId()));
        result.setId(id);
        result.setGrantId(this.getGrantId());
        result.setCreationDate(p_token.getCreationDate());
        result.setExpirationDate(p_token.getExpirationDate());
        result.setTokenCode(TokenHashUtil.getHashedToken(p_token.getCode()));
        result.setUserId(this.getUserId());
        result.setClientId(this.getClientId());
        result.setScope(this.getScopesAsString());
        result.setAuthMode(p_token.getAuthMode());
        result.setSessionDn(p_token.getSessionDn());
        result.setAuthenticationTime(this.getAuthenticationTime());
        AuthorizationGrantType grantType = this.getAuthorizationGrantType();
        if (grantType != null) {
            result.setGrantType(grantType.getParamName());
        }
        if ((authorizationCode = this.getAuthorizationCode()) != null) {
            result.setAuthorizationCode(TokenHashUtil.getHashedToken(authorizationCode.getCode()));
        }
        if ((nonce = this.getNonce()) != null) {
            result.setNonce(nonce);
        }
        if ((jwtRequest = this.getJwtAuthorizationRequest()) != null && StringUtils.isNotBlank((String)jwtRequest.getEncodedJwt())) {
            result.setJwtRequest(jwtRequest.getEncodedJwt());
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void revokeAllTokens() {
        TokenLdap tokenLdap = this.getTokenLdap();
        if (tokenLdap != null && StringUtils.isNotBlank((String)tokenLdap.getGrantId())) {
            this.grantService.removeAllByGrantId(tokenLdap.getGrantId());
        }
    }

    @Override
    public void checkExpiredTokens() {
    }

    public String getSub() {
        User user = this.getUser();
        if (user == null) {
            log.trace("User is null for grant " + this.getGrantId());
            return "";
        }
        String subjectType = this.getClient().getSubjectType();
        if (SubjectType.PAIRWISE.equals((Object)SubjectType.fromString((String)subjectType))) {
            String sectorIdentifierUri = null;
            sectorIdentifierUri = StringUtils.isNotBlank((String)this.getClient().getSectorIdentifierUri()) ? this.getClient().getSectorIdentifierUri() : this.getClient().getRedirectUris()[0];
            String userInum = user.getAttribute("inum");
            String clientId = this.getClientId();
            try {
                PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, clientId);
                if (pairwiseIdentifier == null) {
                    pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId);
                    pairwiseIdentifier.setId(UUID.randomUUID().toString());
                    pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                    this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
                }
                return pairwiseIdentifier.getId();
            }
            catch (Exception e) {
                log.error("Failed to get sub claim. PairwiseIdentifierService failed to find pair wise identifier.", (Throwable)e);
                return "";
            }
        }
        return user.getAttribute(this.appConfiguration.getOpenidSubAttribute());
    }

    public boolean isCachedWithNoPersistence() {
        return this.isCachedWithNoPersistence;
    }

    public void setIsCachedWithNoPersistence(boolean isCachedWithNoPersistence) {
        this.isCachedWithNoPersistence = isCachedWithNoPersistence;
    }
}

