/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.Date;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.registration.Client;

public class AuthorizationCodeGrant
extends AuthorizationGrant {
    public AuthorizationCodeGrant() {
    }

    public AuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        this.init(user, client, authenticationTime);
    }

    public void init(User user, Client client, Date authenticationTime) {
        super.init(user, AuthorizationGrantType.AUTHORIZATION_CODE, client, authenticationTime);
        this.setAuthorizationCode(new AuthorizationCode(this.appConfiguration.getAuthorizationCodeLifetime()));
        this.setIsCachedWithNoPersistence(true);
    }

    @Override
    public void revokeAllTokens() {
        super.revokeAllTokens();
        if (this.getAuthorizationCode() != null) {
            this.getAuthorizationCode().setRevoked(true);
        }
    }

    @Override
    public void checkExpiredTokens() {
        super.checkExpiredTokens();
        if (this.getAuthorizationCode() != null) {
            this.getAuthorizationCode().checkExpired();
        }
    }
}

