/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.introspection.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.IntrospectionResponse;
import org.xdi.oxauth.model.common.TokenType;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.UmaScopeType;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.external.ExternalIntrospectionService;
import org.xdi.oxauth.service.external.context.ExternalIntrospectionContext;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.Pair;

@Path(value="/introspection")
@Api(value="/introspection", description="The Introspection Endpoint is an OAuth 2 Endpoint that responds to    HTTP GET and HTTP POST requests from token holders.  The endpoint    takes a single parameter representing the token (and optionally    further authentication) and returns a JSON document representing the meta information surrounding the token.")
public class IntrospectionWebService {
    private static final Pair<AuthorizationGrant, Boolean> EMPTY = new Pair(null, (Object)false);
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private TokenService tokenService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalIntrospectionService externalIntrospectionService;
    @Inject
    private AttributeService attributeService;

    @GET
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=400, message="invalid_request\nThe request is missing a required parameter, includes an unsupported parameter or parameter value, repeats the same parameter or is otherwise malformed.  The resource server SHOULD respond with the HTTP 400 (Bad Request) status code."), @ApiResponse(code=500, message="Introspection Internal Server Failed.")})
    public Response introspectGet(@HeaderParam(value="Authorization") String p_authorization, @QueryParam(value="token") String p_token, @QueryParam(value="token_type_hint") String tokenTypeHint, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(p_authorization, p_token, tokenTypeHint, httpRequest, httpResponse);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String p_authorization, @FormParam(value="token") String p_token, @FormParam(value="token_type_hint") String tokenTypeHint, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(p_authorization, p_token, tokenTypeHint, httpRequest, httpResponse);
    }

    private Response introspect(String p_authorization, String p_token, String tokenTypeHint, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            this.log.trace("Introspect token, authorization: {}, token to introsppect: {}, tokenTypeHint:", new Object[]{p_authorization, p_token, tokenTypeHint});
            if (StringUtils.isNotBlank((String)p_authorization) && StringUtils.isNotBlank((String)p_token)) {
                Pair<AuthorizationGrant, Boolean> pair = this.getAuthorizationGrant(p_authorization, p_token);
                AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getFirst();
                if (authorizationGrant != null) {
                    AbstractToken authorizationAccessToken = authorizationGrant.getAccessToken(this.tokenService.getTokenFromAuthorizationParameter(p_authorization));
                    if (authorizationAccessToken != null && authorizationAccessToken.isValid() || ((Boolean)pair.getSecond()).booleanValue()) {
                        if (ServerUtil.isTrue(this.appConfiguration.getIntrospectionAccessTokenMustHaveUmaProtectionScope()) && !authorizationGrant.getScopesAsString().contains(UmaScopeType.PROTECTION.getValue())) {
                            this.log.trace("access_token used to access introspection endpoint does not have uma_protection scope, however in oxauth configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true");
                            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED) + " access_token does not have uma_protection scope which is required by OP configuration.")).build();
                        }
                        IntrospectionResponse response = new IntrospectionResponse(false);
                        AuthorizationGrant grantOfIntrospectionToken = this.authorizationGrantList.getAuthorizationGrantByAccessToken(p_token);
                        if (grantOfIntrospectionToken != null) {
                            AbstractToken tokenToIntrospect = grantOfIntrospectionToken.getAccessToken(p_token);
                            User user = grantOfIntrospectionToken.getUser();
                            response.setActive(tokenToIntrospect.isValid());
                            response.setExpiresAt(ServerUtil.dateToSeconds(tokenToIntrospect.getExpirationDate()));
                            response.setIssuedAt(ServerUtil.dateToSeconds(tokenToIntrospect.getCreationDate()));
                            response.setAcrValues(grantOfIntrospectionToken.getAcrValues());
                            response.setScopes(grantOfIntrospectionToken.getScopes() != null ? grantOfIntrospectionToken.getScopes() : new ArrayList());
                            response.setScope(grantOfIntrospectionToken.getScopes() != null ? grantOfIntrospectionToken.getScopes() : new ArrayList());
                            response.setClientId(grantOfIntrospectionToken.getClientId());
                            response.setSub(grantOfIntrospectionToken.getSub());
                            response.setUsername(user != null ? user.getAttribute("displayName") : null);
                            response.setIssuer(this.appConfiguration.getIssuer());
                            response.setAudience(grantOfIntrospectionToken.getClientId());
                            if (tokenToIntrospect instanceof AccessToken) {
                                AccessToken accessToken = (AccessToken)tokenToIntrospect;
                                response.setTokenType(accessToken.getTokenType() != null ? accessToken.getTokenType().getName() : TokenType.BEARER.getName());
                            }
                        } else {
                            this.log.error("Failed to find grant for access_token: " + p_token + ". Return 200 with active=false.");
                        }
                        JSONObject responseAsJsonObject = new JSONObject(ServerUtil.asJson(response));
                        ExternalIntrospectionContext context = new ExternalIntrospectionContext(authorizationGrant, httpRequest, httpResponse, this.appConfiguration, this.attributeService);
                        if (this.externalIntrospectionService.executeExternalModifyResponse(responseAsJsonObject, context)) {
                            this.log.trace("Successfully run extenal introspection scripts.");
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseAsJsonObject.toString()).build();
                        }
                        return Response.status((Response.Status)Response.Status.OK).entity((Object)ServerUtil.asJson(response)).build();
                    }
                    this.log.error("Access token is not valid. Valid: " + (authorizationAccessToken != null && authorizationAccessToken.isValid()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED)).build();
                }
                this.log.error("Authorization grant is null.");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED)).build();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST)).build();
    }

    private Pair<AuthorizationGrant, Boolean> getAuthorizationGrant(String authorization, String accessToken) throws UnsupportedEncodingException {
        String encodedCredentials;
        String token;
        int delim;
        AuthorizationGrant grant = this.tokenService.getAuthorizationGrantByPrefix(authorization, "Bearer ");
        if (grant != null) {
            String authorizationAccessToken = authorization.substring("Bearer ".length());
            AbstractToken accessTokenObject = grant.getAccessToken(authorizationAccessToken);
            if (accessTokenObject != null && accessTokenObject.isValid()) {
                return new Pair((Object)grant, (Object)false);
            }
            this.log.error("Access token is not valid: " + authorizationAccessToken);
            return EMPTY;
        }
        grant = this.tokenService.getAuthorizationGrantByPrefix(authorization, "Basic ");
        if (grant != null) {
            return new Pair((Object)grant, (Object)false);
        }
        if (StringUtils.startsWithIgnoreCase((String)authorization, (String)"Basic ") && (delim = (token = new String(Base64.decodeBase64((String)(encodedCredentials = authorization.substring("Basic ".length()))), "UTF-8")).indexOf(":")) != -1) {
            String password;
            String clientId = URLDecoder.decode(token.substring(0, delim), "UTF-8");
            if (this.clientService.authenticate(clientId, password = URLDecoder.decode(token.substring(delim + 1), "UTF-8"))) {
                grant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
                if (grant != null && !grant.getClientId().equals(clientId)) {
                    this.log.trace("Failed to match grant object clientId and client id provided during authentication.");
                    return EMPTY;
                }
                return new Pair((Object)grant, (Object)true);
            }
            this.log.trace("Failed to perform basic authentication for client: " + clientId);
        }
        return EMPTY;
    }
}

