/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.idgen.ws.rs;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.LdapDummyEntry;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.config.BaseDnConfiguration;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.util.INumGenerator;

@Stateless
@Named(value="inumGenerator")
public class InumGenerator {
    public static final String SEPARATOR = "!";
    private static final int MAX = 100;
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public String generateId(String p_idType, String p_idPrefix) {
        IdType idType = IdType.fromString((String)p_idType);
        if (idType != null) {
            return this.generateId(idType, p_idPrefix);
        }
        this.log.error("Unable to identify id type: {}", (Object)p_idType);
        return "";
    }

    public String generateId(IdType p_idType, String p_idPrefix) {
        String inum;
        int counter = 0;
        try {
            while (true) {
                StringBuilder sb = new StringBuilder();
                sb.append(p_idPrefix).append(SEPARATOR).append(p_idType.getInum()).append(SEPARATOR);
                if (IdType.CLIENTS == p_idType || IdType.PEOPLE == p_idType) {
                    sb.append(INumGenerator.generate((int)4));
                } else {
                    sb.append(INumGenerator.generate((int)2));
                }
                inum = sb.toString();
                if (StringUtils.isBlank((String)inum)) {
                    this.log.error("Unable to generate inum: {}", (Object)inum);
                } else if (this.contains(inum, p_idType)) {
                    if (counter > 100) {
                        this.log.error("Infinite loop problem while generating new inum");
                        return "";
                    }
                    ++counter;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            inum = e.getMessage();
        }
        this.log.trace("Generated inum: {}", (Object)inum);
        return inum;
    }

    public boolean contains(String inum, IdType type) {
        String baseDn = this.baseDn(type);
        try {
            Filter filter = Filter.create((String)String.format("inum=%s", inum));
            List entries = this.ldapEntryManager.findEntries(baseDn, LdapDummyEntry.class, filter);
            return entries != null && !entries.isEmpty();
        }
        catch (LDAPException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String baseDn(IdType p_type) {
        BaseDnConfiguration baseDn = this.staticConfiguration.getBaseDn();
        switch (p_type) {
            case CLIENTS: {
                return baseDn.getClients();
            }
            case APPLIANCE: {
                return baseDn.getAppliance();
            }
            case ATTRIBUTE: {
                return baseDn.getAttributes();
            }
            case PEOPLE: {
                return baseDn.getPeople();
            }
        }
        try {
            DN dnObj = new DN(baseDn.getClients());
            RDN[] rdns = dnObj.getRDNs();
            RDN rdn = rdns[rdns.length - 1];
            return rdn.toNormalizedString();
        }
        catch (LDAPException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.log.error("Use fallback DN: o=gluu, for ID generator, please check oxAuth configuration, clientDn must be valid DN");
            return "o=gluu";
        }
    }
}

