/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.idgen.ws.rs;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xdi.oxauth.idgen.ws.rs.InumGenerator;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.service.api.IdGenerator;
import org.xdi.oxauth.service.external.ExternalIdGeneratorService;
import org.xdi.util.StringHelper;

@Stateless
@Named(value="idGenService")
public class IdGenService
implements IdGenerator {
    @Inject
    private Logger log;
    @Inject
    private InumGenerator inumGenerator;
    @Inject
    private ExternalIdGeneratorService externalIdGeneratorService;

    public String generateId(IdType p_idType, String p_idPrefix) {
        return this.generateId(p_idType.getType(), p_idPrefix);
    }

    public String generateId(String p_idType, String p_idPrefix) {
        String generatedId;
        if (this.externalIdGeneratorService.isEnabled() && StringHelper.isNotEmpty((String)(generatedId = this.externalIdGeneratorService.executeExternalDefaultGenerateIdMethod("oxauth", p_idType, p_idPrefix)))) {
            return generatedId;
        }
        return this.inumGenerator.generateId(p_idType, p_idPrefix);
    }
}

