/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.i18n;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.util.Strings;

@Named(value="language")
@RequestScoped
public class LanguageBean
implements Serializable {
    private static final long serialVersionUID = -6723715664277907737L;
    private static final String COOKIE_NAME = "org.gluu.i18n.Locale";
    private static final int DEFAULT_MAX_AGE = 31536000;
    private static final String COOKIE_PATH = "/";
    private String localeCode = Locale.ENGLISH.getLanguage();

    public String getLocaleCode() {
        try {
            String localeCode = this.getCookieValue();
            if (localeCode != null) {
                this.setLocaleCode(localeCode);
            }
            return this.localeCode;
        }
        catch (Exception e) {
            return this.localeCode;
        }
    }

    public void setLocaleCode(String localeCode) {
        Iterator locales = FacesContext.getCurrentInstance().getApplication().getSupportedLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            if (Strings.isEmpty((CharSequence)locale.getLanguage()) || !locale.getLanguage().equals(localeCode)) continue;
            this.localeCode = localeCode;
            FacesContext.getCurrentInstance().getViewRoot().setLocale(new Locale(localeCode));
            this.setCookieValue(localeCode);
            break;
        }
    }

    public String getMessage(String key) {
        String result;
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplication().getResourceBundle(context, "msgs");
        try {
            result = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = "???" + key + "??? not found";
        }
        return result;
    }

    private void setCookieValue(String value) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)ctx.getExternalContext().getResponse();
        Cookie cookie = new Cookie(COOKIE_NAME, value);
        cookie.setMaxAge(31536000);
        cookie.setPath(COOKIE_PATH);
        cookie.setSecure(true);
        cookie.setVersion(1);
        response.addCookie(cookie);
    }

    private String getCookieValue() {
        Cookie cookie = this.getCookie();
        return cookie == null ? null : cookie.getValue();
    }

    private Cookie getCookie() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            return (Cookie)ctx.getExternalContext().getRequestCookieMap().get(COOKIE_NAME);
        }
        return null;
    }
}

