/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.gluu.ws.rs;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.model.GluuAttribute;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.gluu.GluuConfiguration;
import org.xdi.oxauth.model.gluu.GluuErrorResponseType;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/.well-known/gluu-configuration")
@Api(value="/.well-known/gluu-configuration", description="Endpoint for non-standard OpenID Connect discovery configuration data in a JSON [RFC4627] document that resides in at /.well-known/gluu-configuration directory at its hostmeta [hostmeta] location. The configuration data documents conformance options and endpoints supported by the Gluu server.")
public class GluuConfigurationWS {
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Provides configuration data as json document. It contains non-standard OpenID Connect discovery metadata supported by the Gluu server.", response=GluuConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Failed to build gluu configuration json object.")})
    public Response getConfiguration() {
        try {
            GluuConfiguration conf = new GluuConfiguration();
            conf.setIdGenerationEndpoint(this.appConfiguration.getIdGenerationEndpoint());
            conf.setIntrospectionEndpoint(this.appConfiguration.getIntrospectionEndpoint());
            conf.setAuthLevelMapping(this.createAuthLevelMapping());
            conf.setScopeToClaimsMapping(this.createScopeToClaimsMapping());
            String entity = ServerUtil.asPrettyJson(conf);
            this.log.trace("Gluu configuration: {}", (Object)entity);
            return Response.ok((Object)entity).build();
        }
        catch (Throwable ex) {
            this.log.error(ex.getMessage(), ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)GluuErrorResponseType.SERVER_ERROR)).build());
        }
    }

    public Map<Integer, Set<String>> createAuthLevelMapping() {
        HashMap map = Maps.newHashMap();
        try {
            for (CustomScriptConfiguration script : this.externalAuthenticationService.getCustomScriptConfigurationsMap()) {
                String acr = script.getName();
                int level = script.getLevel();
                Set acrs = (Set)map.get(level);
                if (acrs == null) {
                    acrs = Sets.newHashSet();
                    map.put(level, acrs);
                }
                acrs.add(acr);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private Map<String, Set<String>> createScopeToClaimsMapping() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try {
            for (Scope scope : this.scopeService.getAllScopesList()) {
                HashSet<String> claimsList = new HashSet<String>();
                result.put(scope.getDisplayName(), claimsList);
                List<String> claimIdList = scope.getOxAuthClaims();
                if (claimIdList == null || claimIdList.isEmpty()) continue;
                for (String claimDn : claimIdList) {
                    GluuAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = attribute.getOxAuthClaimName();
                    if (!StringUtils.isNotBlank((String)claimName)) continue;
                    claimsList.add(claimName);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

