/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.clientinfo.ws.rs;

import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.clientinfo.ws.rs.ClientInfoRestWebService;
import org.xdi.oxauth.model.clientinfo.ClientInfoErrorResponseType;
import org.xdi.oxauth.model.clientinfo.ClientInfoParamsValidator;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.ScopeService;

@Path(value="/")
public class ClientInfoRestWebServiceImpl
implements ClientInfoRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ClientService clientService;
    @Inject
    private AttributeService attributeService;

    @Override
    public Response requestClientInfoGet(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestClientInfo(accessToken, authorization, securityContext);
    }

    @Override
    public Response requestClientInfoPost(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestClientInfo(accessToken, authorization, securityContext);
    }

    public Response requestClientInfo(String accessToken, String authorization, SecurityContext securityContext) {
        if (authorization != null && !authorization.isEmpty() && authorization.startsWith("Bearer ")) {
            accessToken = authorization.substring(7);
        }
        this.log.debug("Attempting to request Client Info, Access token = {}, Is Secure = {}", new Object[]{accessToken, securityContext.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        if (!ClientInfoParamsValidator.validateParams(accessToken)) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson(ClientInfoErrorResponseType.INVALID_REQUEST));
        } else {
            AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (authorizationGrant == null) {
                this.log.trace("Failed to find authorization grant for access token.");
                return Response.status((int)400).entity((Object)this.errorResponseFactory.getErrorAsJson(ClientInfoErrorResponseType.INVALID_TOKEN)).build();
            }
            AbstractToken token = authorizationGrant.getAccessToken(accessToken);
            if (token == null || !token.isValid()) {
                this.log.trace("Invalid access token.");
                return Response.status((int)400).entity((Object)this.errorResponseFactory.getErrorAsJson(ClientInfoErrorResponseType.INVALID_TOKEN)).build();
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setPrivate(true);
            cacheControl.setNoTransform(false);
            cacheControl.setNoStore(true);
            builder.cacheControl(cacheControl);
            builder.header("Pragma", (Object)"no-cache");
            builder.entity((Object)this.getJSonResponse(authorizationGrant.getClient(), authorizationGrant.getScopes()));
        }
        return builder.build();
    }

    public String getJSonResponse(Client client, Set<String> scopes) {
        JSONObject jsonObj = new JSONObject();
        try {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
                if (scope.getOxAuthClaims() == null) continue;
                for (String claimDn : scope.getOxAuthClaims()) {
                    GluuAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String attributeName = attribute.getName();
                    Object attributeValue = this.clientService.getAttribute(client, attribute.getName());
                    jsonObj.put(attributeName, attributeValue);
                }
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }
}

