/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.cert.validation.model;

import java.security.cert.X509Certificate;
import java.util.Date;

public class ValidationStatus {
    private X509Certificate certificate;
    private X509Certificate issuer;
    private CertificateValidity validity;
    private ValidatorSourceType sourceType;
    private Date revocationObjectIssuingTime;
    private Date revocationDate;
    private Date validationDate;

    public ValidationStatus(X509Certificate certificate, X509Certificate issuer, Date validationDate, ValidatorSourceType sourceType, CertificateValidity validity) {
        this.certificate = certificate;
        this.issuer = issuer;
        this.validationDate = validationDate;
        this.sourceType = sourceType;
        this.validity = validity;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getIssuer() {
        return this.issuer;
    }

    public void setIssuer(X509Certificate issuer) {
        this.issuer = issuer;
    }

    public CertificateValidity getValidity() {
        return this.validity;
    }

    public void setValidity(CertificateValidity validity) {
        this.validity = validity;
    }

    public ValidatorSourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(ValidatorSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public Date getRevocationObjectIssuingTime() {
        return this.revocationObjectIssuingTime;
    }

    public void setRevocationObjectIssuingTime(Date revocationObjectIssuingTime) {
        this.revocationObjectIssuingTime = revocationObjectIssuingTime;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(Date revocationDate) {
        this.revocationDate = revocationDate;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CertificateValidationStatus [certificate=").append(this.certificate.getSerialNumber()).append(", issuer=").append(this.issuer.getSerialNumber()).append(", validity=").append((Object)this.validity).append(", sourceType=").append((Object)this.sourceType).append(", revocationObjectIssuingTime=").append(this.revocationObjectIssuingTime).append(", revocationDate=").append(this.revocationDate).append(", validationDate=").append(this.validationDate).append("]");
        return builder.toString();
    }

    public static enum CertificateValidity {
        VALID,
        INVALID,
        REVOKED,
        UNKNOWN;

    }

    public static enum ValidatorSourceType {
        OCSP,
        CRL,
        APP,
        CHAIN,
        SELF_SIGNED;

    }
}

