/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.cert.validation;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.cert.validation.CertificateVerifier;
import org.xdi.oxauth.cert.validation.model.ValidationStatus;
import org.xdi.oxauth.model.util.SecurityProviderUtility;

public class GenericCertificateVerifier
implements CertificateVerifier {
    private static final Logger log = LoggerFactory.getLogger(GenericCertificateVerifier.class);

    public GenericCertificateVerifier() {
        SecurityProviderUtility.installBCProvider((boolean)true);
    }

    @Override
    public ValidationStatus validate(X509Certificate certificate, List<X509Certificate> issuers, Date validationDate) {
        X509Certificate issuer = issuers.get(0);
        ValidationStatus status = new ValidationStatus(certificate, issuer, validationDate, ValidationStatus.ValidatorSourceType.APP, ValidationStatus.CertificateValidity.UNKNOWN);
        try {
            X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
            try {
                log.debug("Validity status is valid for '" + subjectX500Principal + "'");
                certificate.checkValidity(validationDate);
                status.setValidity(ValidationStatus.CertificateValidity.VALID);
            }
            catch (CertificateExpiredException ex) {
                log.debug("Validity status is expied for '" + subjectX500Principal + "'");
            }
            catch (CertificateNotYetValidException ex) {
                log.warn("Validity status is not yet valid for '" + subjectX500Principal + "'");
            }
        }
        catch (Exception ex) {
            log.error("CRL exception: ", (Throwable)ex);
        }
        return status;
    }

    @Override
    public void destroy() {
    }
}

