/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.authorize.ws.rs;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserService;

@Stateless
@Named
public class ConsentGatheringSessionService {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private UserService userService;
    @Inject
    private ClientService clientService;

    public SessionId getConnectSession(HttpServletRequest httpRequest) {
        String cookieId = this.sessionIdService.getSessionIdFromCookie(httpRequest);
        this.log.trace("Cookie - session_id: ", (Object)cookieId);
        if (StringUtils.isNotBlank((String)cookieId)) {
            return this.sessionIdService.getSessionId(cookieId);
        }
        return null;
    }

    public boolean hasSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String cookieId = this.sessionIdService.getConsentSessionIdFromCookie(httpRequest);
        return StringUtils.isNotBlank((String)cookieId);
    }

    public SessionId getConsentSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String userDn, boolean create) {
        String cookieId = this.sessionIdService.getConsentSessionIdFromCookie(httpRequest);
        this.log.trace("Cookie - consent_session_id: ", (Object)cookieId);
        if (StringUtils.isNotBlank((String)cookieId)) {
            SessionId sessionId = this.sessionIdService.getSessionId(cookieId);
            if (sessionId != null) {
                this.log.trace("Loaded consent_session_id from cookie, session: ", (Object)sessionId);
                return sessionId;
            }
            this.log.error("Failed to load consent_session_id from cookie: ", (Object)cookieId);
        } else if (!create) {
            this.log.error("consent_session_id cookie is not set.");
        }
        if (!create) {
            return null;
        }
        this.log.trace("Generating new consent_session_id ...");
        SessionId session = this.sessionIdService.generateUnauthenticatedSessionId(userDn);
        this.sessionIdService.createSessionIdCookie(session.getId(), session.getSessionState(), session.getOPBrowserState(), httpResponse, "consent_session_id");
        this.log.trace("consent_session_id cookie created.");
        return session;
    }

    public void setAuthenticatedSessionState(HttpServletRequest httpRequest, SessionId sessionId) {
        SessionId connectSession = this.getConnectSession(httpRequest);
        this.sessionIdService.setSessionIdStateAuthenticated(httpRequest, sessionId, connectSession.getDn());
    }

    public boolean isSessionStateAuthenticated(HttpServletRequest httpRequest) {
        boolean hasSession = this.hasSession(httpRequest, null);
        if (hasSession) {
            SessionId session = this.getConsentSession(httpRequest, null, null, false);
            return this.sessionIdService.isSessionIdAuthenticated(session);
        }
        return false;
    }

    public boolean persist(SessionId session) {
        try {
            if (this.sessionIdService.persistSessionId(session, true)) {
                this.log.trace("Session persisted successfully. Session: " + session);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to persist session, id: " + session.getId(), (Throwable)e);
        }
        return false;
    }

    public int getStep(SessionId session) {
        String stepString = session.getSessionAttributes().get("step");
        int step = Util.parseIntSilently((String)stepString);
        if (step == -1) {
            step = 1;
            this.setStep(step, session);
        }
        return step;
    }

    public void setStep(int step, SessionId session) {
        session.getSessionAttributes().put("step", Integer.toString(step));
    }

    public void configure(SessionId session, String scriptName, String clientId, String state) {
        this.setStep(1, session);
        this.setScriptName(session, scriptName);
        this.setClientId(session, clientId);
        this.persist(session);
    }

    public boolean isStepPassed(SessionId session, Integer step) {
        return Boolean.parseBoolean(session.getSessionAttributes().get(String.format("consent_step_passed_%d", step)));
    }

    public boolean isPassedPreviousSteps(SessionId session, Integer step) {
        for (int i = 1; i < step; ++i) {
            if (this.isStepPassed(session, i)) continue;
            return false;
        }
        return true;
    }

    public void markStep(SessionId session, Integer step, boolean value) {
        String key = String.format("consent_step_passed_%d", step);
        if (value) {
            session.getSessionAttributes().put(key, Boolean.TRUE.toString());
        } else {
            session.getSessionAttributes().remove(key);
        }
    }

    public String getScriptName(SessionId session) {
        return session.getSessionAttributes().get("gather_script_name");
    }

    public void setScriptName(SessionId session, String scriptName) {
        session.getSessionAttributes().put("gather_script_name", scriptName);
    }

    public String getClientId(SessionId session) {
        return session.getSessionAttributes().get("client_id");
    }

    public void setClientId(SessionId session, String clientId) {
        session.getSessionAttributes().put("client_id", clientId);
    }

    public void resetToStep(SessionId session, int overridenNextStep, int step) {
        for (int i = overridenNextStep; i <= step; ++i) {
            this.markStep(session, i, false);
        }
        this.setStep(overridenNextStep, session);
    }

    public User getUser(HttpServletRequest httpRequest, String ... returnAttributes) {
        String userDn = this.getUserDn(httpRequest);
        if (StringUtils.isNotBlank((String)userDn)) {
            return this.userService.getUserByDn(userDn, returnAttributes);
        }
        return null;
    }

    public String getUserDn(HttpServletRequest httpRequest) {
        SessionId connectSession = this.getConnectSession(httpRequest);
        if (connectSession != null) {
            return connectSession.getUserDn();
        }
        this.log.trace("No logged in user.");
        return null;
    }

    public Client getClient(SessionId session) {
        String clientId = this.getClientId(session);
        if (StringUtils.isNotBlank((String)clientId)) {
            return this.clientService.getClient(clientId);
        }
        this.log.trace("client_id is not in session.");
        return null;
    }
}

