/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.authorize.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Api(value="/", description="The Authorization Endpoint performs Authentication of the End-User. This is done by sending the User Agent to the Authorization Server's Authorization Endpoint for Authentication and Authorization, using request parameters defined by OAuth 2.0 and additional parameters and parameter values defined by OpenID Connect.")
public interface AuthorizeRestWebService {
    @GET
    @Path(value="/authorize")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Performs authorization.", notes="The Authorization Endpoint performs Authentication of the End-User.", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=302, message="interaction_required\n    The Authorization Server requires End-User interaction of some form to proceed. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface for End-User interaction. "), @ApiResponse(code=302, message="login_required\n    The Authorization Server requires End-User authentication. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface for End-User authentication. "), @ApiResponse(code=302, message="account_selection_required\n    The End-User is REQUIRED to select a session at the Authorization Server. The End-User MAY be authenticated at the Authorization Server with different associated accounts, but the End-User did not select a session. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface to prompt for a session to use. "), @ApiResponse(code=302, message="consent_required\n    The Authorization Server requires End-User consent. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface for End-User consent. "), @ApiResponse(code=302, message="invalid_request_uri\n    The request_uri in the Authorization Request returns an error or contains invalid data. "), @ApiResponse(code=302, message="invalid_request_object\n    The request parameter contains an invalid Request Object. "), @ApiResponse(code=302, message="request_not_supported\n    The OP does not support use of the request parameter"), @ApiResponse(code=302, message="request_uri_not_supported\n    The OP does not support use of the request_uri parameter"), @ApiResponse(code=302, message="registration_not_supported\n    The OP does not support use of the registration parameter")})
    public Response requestAuthorizationGet(@QueryParam(value="scope") @ApiParam(value="OpenID Connect requests MUST contain the openid scope value. If the openid scope value is not present, the behavior is entirely unspecified. Other scope values MAY be present. Scope values used that are not understood by an implementation SHOULD be ignored.", required=true) String var1, @QueryParam(value="response_type") @ApiParam(value="OAuth 2.0 Response Type value that determines the authorization processing flow to be used, including what parameters are returned from the endpoints used. When using the Authorization Code Flow, this value is code. ", required=true) String var2, @QueryParam(value="client_id") @ApiParam(value="OAuth 2.0 Client Identifier valid at the Authorization Server.", required=true) String var3, @QueryParam(value="redirect_uri") @ApiParam(value="Redirection URI to which the response will be sent. This URI MUST exactly match one of the Redirection URI values for the Client pre-registered at the OpenID Provider", required=true) String var4, @QueryParam(value="state") @ApiParam(value="Opaque value used to maintain state between the request and the callback. Typically, Cross-Site Request Forgery (CSRF, XSRF) mitigation is done by cryptographically binding the value of this parameter with a browser cookie. ", required=false) String var5, @QueryParam(value="response_mode") @ApiParam(value="Informs the Authorization Server of the mechanism to be used for returning parameters from the Authorization Endpoint. This use of this parameter is NOT RECOMMENDED when the Response Mode that would be requested is the default mode specified for the Response Type. ", required=false) String var6, @QueryParam(value="nonce") @ApiParam(value="String value used to associate a Client session with an ID Token, and to mitigate replay attacks. The value is passed through unmodified from the Authorization Request to the ID Token. Sufficient entropy MUST be present in the nonce values used to prevent attackers from guessing values.", required=false) String var7, @QueryParam(value="display") @ApiParam(value="ASCII string value that specifies how the Authorization Server displays the authentication and consent user interface pages to the End-User. The defined values are: page, popup, touch, wap", required=false) String var8, @QueryParam(value="prompt") @ApiParam(value="Space delimited, case sensitive list of ASCII string values that specifies whether the Authorization Server prompts the End-User for reauthentication and consent. The defined values are: none, login, consent, select_account", required=false) String var9, @QueryParam(value="max_age") @ApiParam(value="Maximum Authentication Age. Specifies the allowable elapsed time in seconds since the last time the End-User was actively authenticated by the OP. If the elapsed time is greater than this value, the OP MUST attempt to actively re-authenticate the End-User. (The max_age request parameter corresponds to the OpenID 2.0 PAPE [OpenID.PAPE] max_auth_age request parameter.) When max_age is used, the ID Token returned MUST include an auth_time Claim Value. ", required=false) Integer var10, @QueryParam(value="ui_locales") @ApiParam(value="End-User's preferred languages and scripts for the user interface, represented as a space-separated list of BCP47 [RFC5646] language tag values, ordered by preference. For instance, the value \"fr-CA fr en\" represents a preference for French as spoken in Canada, then French (without a region designation), followed by English (without a region designation). An error SHOULD NOT result if some or all of the requested locales are not supported by the OpenID Provider. ", required=false) String var11, @QueryParam(value="id_token_hint") @ApiParam(value="ID Token previously issued by the Authorization Server being passed as a hint about the End-User's current or past authenticated session with the Client. If the End-User identified by the ID Token is logged in or is logged in by the request, then the Authorization Server returns a positive response; otherwise, it SHOULD return an error, such as login_required. When possible, an id_token_hint SHOULD be present when prompt=none is used and an invalid_request error MAY be returned if it is not; however, the server SHOULD respond successfully when possible, even if it is not present. The Authorization Server need not be listed as an audience of the ID Token when it is used as an id_token_hint value. ", required=false) String var12, @QueryParam(value="login_hint") @ApiParam(value="Hint to the Authorization Server about the login identifier the End-User might use to log in (if necessary). This hint can be used by an RP if it first asks the End-User for their e-mail address (or other identifier) and then wants to pass that value as a hint to the discovered authorization service. It is RECOMMENDED that the hint value match the value used for discovery. This value MAY also be a phone number in the format specified for the phone_number Claim. The use of this parameter is left to the OP's discretion. ", required=false) String var13, @QueryParam(value="acr_values") @ApiParam(value="Requested Authentication Context Class Reference values. Space-separated string that specifies the acr values that the Authorization Server is being requested to use for processing this Authentication Request, with the values appearing in order of preference. The Authentication Context Class satisfied by the authentication performed is returned as the acr Claim Value, as specified in Section 2. The acr Claim is requested as a Voluntary Claim by this parameter. ", required=false) String var14, @QueryParam(value="amr_values") @ApiParam(value="AMR Values", required=false) String var15, @QueryParam(value="request") @ApiParam(value="This parameter enables OpenID Connect requests to be passed in a single, self-contained parameter and to be optionally signed and/or encrypted. The parameter value is a Request Object value, as specified in Section 6.1. It represents the request as a JWT whose Claims are the request parameters.", required=false) String var16, @QueryParam(value="request_uri") @ApiParam(value="This parameter enables OpenID Connect requests to be passed by reference, rather than by value. The request_uri value is a URL using the https scheme referencing a resource containing a Request Object value, which is a JWT containing the request parameters. ", required=false) String var17, @QueryParam(value="request_session_id") @ApiParam(value="Request session id", required=false) String var18, @QueryParam(value="session_id") @ApiParam(value="Session id of this call", required=false) String var19, @QueryParam(value="access_token") @ApiParam(value="Access token", required=false) String var20, @QueryParam(value="origin_headers") @ApiParam(value="Origin headers. Used in custom workflows.", required=false) String var21, @QueryParam(value="code_challenge") @ApiParam(value="PKCE code challenge.", required=false) String var22, @QueryParam(value="code_challenge_method") @ApiParam(value="PKCE code challenge method.", required=false) String var23, @QueryParam(value="custom_response_headers") @ApiParam(value="Custom Response Headers.", required=false) String var24, @QueryParam(value="claims") @ApiParam(value="Requested Claims.", required=false) String var25, @Context HttpServletRequest var26, @Context HttpServletResponse var27, @Context SecurityContext var28);

    @POST
    @Path(value="/authorize")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Performs authorization.", notes="The Authorization Endpoint performs Authentication of the End-User.", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=302, message="interaction_required\n    The Authorization Server requires End-User interaction of some form to proceed. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface for End-User interaction. "), @ApiResponse(code=302, message="login_required\n    The Authorization Server requires End-User authentication. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface for End-User authentication. "), @ApiResponse(code=302, message="account_selection_required\n    The End-User is REQUIRED to select a session at the Authorization Server. The End-User MAY be authenticated at the Authorization Server with different associated accounts, but the End-User did not select a session. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface to prompt for a session to use. "), @ApiResponse(code=302, message="consent_required\n    The Authorization Server requires End-User consent. This error MAY be returned when the prompt parameter value in the Authentication Request is none, but the Authentication Request cannot be completed without displaying a user interface for End-User consent. "), @ApiResponse(code=302, message="invalid_request_uri\n    The request_uri in the Authorization Request returns an error or contains invalid data. "), @ApiResponse(code=302, message="invalid_request_object\n    The request parameter contains an invalid Request Object. "), @ApiResponse(code=302, message="request_not_supported\n    The OP does not support use of the request parameter"), @ApiResponse(code=302, message="request_uri_not_supported\n    The OP does not support use of the request_uri parameter"), @ApiResponse(code=302, message="registration_not_supported\n    The OP does not support use of the registration parameter")})
    public Response requestAuthorizationPost(@FormParam(value="scope") @ApiParam(value="OpenID Connect requests MUST contain the openid scope value. If the openid scope value is not present, the behavior is entirely unspecified. Other scope values MAY be present. Scope values used that are not understood by an implementation SHOULD be ignored.", required=true) String var1, @FormParam(value="response_type") @ApiParam(value="OAuth 2.0 Response Type value that determines the authorization processing flow to be used, including what parameters are returned from the endpoints used. When using the Authorization Code Flow, this value is code. ", required=true) String var2, @FormParam(value="client_id") @ApiParam(value="OAuth 2.0 Client Identifier valid at the Authorization Server. ", required=true) String var3, @FormParam(value="redirect_uri") @ApiParam(value="Redirection URI to which the response will be sent. This URI MUST exactly match one of the Redirection URI values for the Client pre-registered at the OpenID Provider", required=true) String var4, @FormParam(value="state") @ApiParam(value="Opaque value used to maintain state between the request and the callback. Typically, Cross-Site Request Forgery (CSRF, XSRF) mitigation is done by cryptographically binding the value of this parameter with a browser cookie. ", required=false) String var5, @QueryParam(value="response_mode") @ApiParam(value="Informs the Authorization Server of the mechanism to be used for returning parameters from the Authorization Endpoint. This use of this parameter is NOT RECOMMENDED when the Response Mode that would be requested is the default mode specified for the Response Type. ", required=false) String var6, @FormParam(value="nonce") @ApiParam(value="String value used to associate a Client session with an ID Token, and to mitigate replay attacks. The value is passed through unmodified from the Authorization Request to the ID Token. Sufficient entropy MUST be present in the nonce values used to prevent attackers from guessing values.", required=false) String var7, @FormParam(value="display") @ApiParam(value="ASCII string value that specifies how the Authorization Server displays the authentication and consent user interface pages to the End-User. The defined values are: page, popup, touch, wap", required=false) String var8, @FormParam(value="prompt") @ApiParam(value="Space delimited, case sensitive list of ASCII string values that specifies whether the Authorization Server prompts the End-User for reauthentication and consent. The defined values are: none, login, consent, select_account", required=false) String var9, @FormParam(value="max_age") @ApiParam(value="Maximum Authentication Age. Specifies the allowable elapsed time in seconds since the last time the End-User was actively authenticated by the OP. If the elapsed time is greater than this value, the OP MUST attempt to actively re-authenticate the End-User. (The max_age request parameter corresponds to the OpenID 2.0 PAPE [OpenID.PAPE] max_auth_age request parameter.) When max_age is used, the ID Token returned MUST include an auth_time Claim Value. ", required=false) Integer var10, @FormParam(value="ui_locales") @ApiParam(value="End-User's preferred languages and scripts for the user interface, represented as a space-separated list of BCP47 [RFC5646] language tag values, ordered by preference. For instance, the value \"fr-CA fr en\" represents a preference for French as spoken in Canada, then French (without a region designation), followed by English (without a region designation). An error SHOULD NOT result if some or all of the requested locales are not supported by the OpenID Provider. ", required=false) String var11, @FormParam(value="id_token_hint") @ApiParam(value="ID Token previously issued by the Authorization Server being passed as a hint about the End-User's current or past authenticated session with the Client. If the End-User identified by the ID Token is logged in or is logged in by the request, then the Authorization Server returns a positive response; otherwise, it SHOULD return an error, such as login_required. When possible, an id_token_hint SHOULD be present when prompt=none is used and an invalid_request error MAY be returned if it is not; however, the server SHOULD respond successfully when possible, even if it is not present. The Authorization Server need not be listed as an audience of the ID Token when it is used as an id_token_hint value. ", required=false) String var12, @FormParam(value="login_hint") @ApiParam(value="Hint to the Authorization Server about the login identifier the End-User might use to log in (if necessary). This hint can be used by an RP if it first asks the End-User for their e-mail address (or other identifier) and then wants to pass that value as a hint to the discovered authorization service. It is RECOMMENDED that the hint value match the value used for discovery. This value MAY also be a phone number in the format specified for the phone_number Claim. The use of this parameter is left to the OP's discretion. ", required=false) String var13, @FormParam(value="acr_values") @ApiParam(value="Requested Authentication Context Class Reference values. Space-separated string that specifies the acr values that the Authorization Server is being requested to use for processing this Authentication Request, with the values appearing in order of preference. The Authentication Context Class satisfied by the authentication performed is returned as the acr Claim Value, as specified in Section 2. The acr Claim is requested as a Voluntary Claim by this parameter. ", required=false) String var14, @FormParam(value="amr_values") @ApiParam(value="AMR Values", required=false) String var15, @FormParam(value="request") @ApiParam(value="This parameter enables OpenID Connect requests to be passed in a single, self-contained parameter and to be optionally signed and/or encrypted. The parameter value is a Request Object value, as specified in Section 6.1. It represents the request as a JWT whose Claims are the request parameters.", required=false) String var16, @FormParam(value="request_uri") @ApiParam(value="This parameter enables OpenID Connect requests to be passed by reference, rather than by value. The request_uri value is a URL using the https scheme referencing a resource containing a Request Object value, which is a JWT containing the request parameters. ", required=false) String var17, @FormParam(value="request_session_id") @ApiParam(value="Request session id", required=false) String var18, @FormParam(value="session_id") @ApiParam(value="Session id of this call", required=false) String var19, @FormParam(value="access_token") @ApiParam(value="Access token", required=false) String var20, @FormParam(value="origin_headers") @ApiParam(value="Origin headers. Used in custom workflows.", required=false) String var21, @QueryParam(value="code_challenge") @ApiParam(value="PKCE code challenge.", required=false) String var22, @QueryParam(value="code_challenge_method") @ApiParam(value="PKCE code challenge method.", required=false) String var23, @QueryParam(value="custom_response_headers") @ApiParam(value="Custom Response Headers.", required=false) String var24, @QueryParam(value="claims") @ApiParam(value="Requested Claims.", required=false) String var25, @Context HttpServletRequest var26, @Context HttpServletResponse var27, @Context SecurityContext var28);
}

