/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.fido.u2f;

import com.wordnik.swagger.annotations.Api;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.RegisterRequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequestMessage;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterStatus;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RegistrationService;
import org.xdi.oxauth.service.fido.u2f.UserSessionStateService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Path(value="/fido/u2f/registration")
@Api(value="/fido/u2f/registration", description="The endpoint at which the U2F device start registration process.")
@Name(value="u2fRegistrationRestWebService")
public class U2fRegistrationWS {
    @Logger
    private Log log;
    @In
    private UserService userService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RegistrationService u2fRegistrationService;
    @In
    private DeviceRegistrationService deviceRegistrationService;
    @In
    private UserSessionStateService userSessionStateService;

    @GET
    @Produces(value={"application/json"})
    public Response startRegistration(@QueryParam(value="username") String userName, @QueryParam(value="application") String appId, @QueryParam(value="session_state") String sessionState) {
        try {
            this.log.debug((Object)"Startig registration with username '{0}' for appId '{1}' and session_state '{2}'", new Object[]{userName, appId, sessionState});
            String userInum = null;
            boolean twoStep = StringHelper.isNotEmpty((String)userName);
            if (twoStep && StringHelper.isEmpty((String)(userInum = this.userService.getUserInum(userName)))) {
                throw new BadInputException(String.format("Failed to find user '%s' in LDAP", userName));
            }
            RegisterRequestMessage registerRequestMessage = this.u2fRegistrationService.builRegisterRequestMessage(appId, userInum);
            this.u2fRegistrationService.storeRegisterRequestMessage(registerRequestMessage, userInum, sessionState);
            String entity = ServerUtil.asJson(registerRequestMessage);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response finishRegistration(@FormParam(value="username") String userName, @FormParam(value="tokenResponse") String registerResponseString) {
        String sessionState = null;
        try {
            this.log.debug((Object)"Finishing registration for username '{0}' with response '{1}'", new Object[]{userName, registerResponseString});
            RegisterResponse registerResponse = (RegisterResponse)ServerUtil.jsonMapperWithWrapRoot().readValue(registerResponseString, RegisterResponse.class);
            String requestId = registerResponse.getRequestId();
            RegisterRequestMessageLdap registerRequestMessageLdap = this.u2fRegistrationService.getRegisterRequestMessageByRequestId(requestId);
            if (registerRequestMessageLdap == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SESSION_EXPIRED)).build());
            }
            this.u2fRegistrationService.removeRegisterRequestMessage(registerRequestMessageLdap);
            String foundUserInum = registerRequestMessageLdap.getUserInum();
            boolean oneStep = StringHelper.isEmpty((String)foundUserInum);
            RegisterRequestMessage registerRequestMessage = registerRequestMessageLdap.getRegisterRequestMessage();
            DeviceRegistration deviceRegistration = this.u2fRegistrationService.finishRegistration(registerRequestMessage, registerResponse, foundUserInum);
            sessionState = registerRequestMessageLdap.getSessionState();
            if (StringHelper.isNotEmpty((String)sessionState)) {
                this.log.debug((Object)"There is session state. Setting session state attributes", new Object[0]);
                this.userSessionStateService.updateUserSessionStateOnFinishRequest(sessionState, foundUserInum, deviceRegistration, true, oneStep);
            }
            RegisterStatus registerStatus = new RegisterStatus("success", requestId);
            String entity = ServerUtil.asJson(registerStatus);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            try {
                if (StringHelper.isNotEmpty(sessionState)) {
                    this.log.debug((Object)"There is session state. Setting session state status to 'declined'", new Object[0]);
                    this.userSessionStateService.updateUserSessionStateOnError(sessionState);
                }
            }
            catch (Exception ex2) {
                this.log.error((Object)"Failed to update session state status", (Throwable)ex2, new Object[0]);
            }
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            if (ex instanceof BadInputException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.INVALID_REQUEST)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }
}

