/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.fido.u2f;

import com.wordnik.swagger.annotations.Api;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.exception.fido.u2f.DeviceCompromisedException;
import org.xdi.oxauth.exception.fido.u2f.InvalidKeyHandleDeviceException;
import org.xdi.oxauth.exception.fido.u2f.NoEligableDevicesException;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.fido.u2f.AuthenticateRequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateRequestMessage;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateStatus;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.fido.u2f.AuthenticationService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.UserSessionStateService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Path(value="/fido/u2f/authentication")
@Api(value="/fido/u2f/registration", description="The endpoint at which the application U2F device start registration process.")
@Name(value="u2fAuthenticationRestWebService")
public class U2fAuthenticationWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private UserService userService;
    @In
    private AuthenticationService u2fAuthenticationService;
    @In
    private DeviceRegistrationService deviceRegistrationService;
    @In
    private UserSessionStateService userSessionStateService;

    @GET
    @Produces(value={"application/json"})
    public Response startAuthentication(@QueryParam(value="username") String userName, @QueryParam(value="keyhandle") String keyHandle, @QueryParam(value="application") String appId, @QueryParam(value="session_state") String sessionState) {
        try {
            this.log.debug((Object)"Startig authentication with username '{0}', keyhandle '{1}' for appId '{2}' and session_state '{3}'", new Object[]{userName, keyHandle, appId, sessionState});
            if (StringHelper.isEmpty((String)userName) && StringHelper.isEmpty((String)keyHandle)) {
                throw new BadInputException(String.format("The request should contains either username or keyhandle", new Object[0]));
            }
            String foundUserInum = null;
            boolean oneStep = StringHelper.isEmpty((String)userName);
            if (oneStep) {
                String keyHandleWithoutPading = Base64Util.base64urlencode((byte[])Base64Util.base64urldecode((String)keyHandle));
                foundUserInum = this.u2fAuthenticationService.getUserInumByKeyHandle(appId, keyHandleWithoutPading);
            } else {
                foundUserInum = this.userService.getUserInum(userName);
            }
            if (StringHelper.isEmpty((String)foundUserInum)) {
                throw new BadInputException(String.format("Failed to find user by userName '%s' or keyHandle '%s' in LDAP", userName, keyHandle));
            }
            AuthenticateRequestMessage authenticateRequestMessage = this.u2fAuthenticationService.buildAuthenticateRequestMessage(appId, foundUserInum);
            this.u2fAuthenticationService.storeAuthenticationRequestMessage(authenticateRequestMessage, foundUserInum, sessionState);
            String entity = ServerUtil.asJson(authenticateRequestMessage);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            if (ex instanceof NoEligableDevicesException || ex instanceof InvalidKeyHandleDeviceException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.NO_ELIGABLE_DEVICES)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response finishAuthentication(@FormParam(value="username") String userName, @FormParam(value="keyhandle") String keyHandle, @FormParam(value="tokenResponse") String authenticateResponseString) {
        String sessionState = null;
        try {
            this.log.debug((Object)"Finishing authentication for username '{0}' with response '{1}'", new Object[]{userName, authenticateResponseString});
            AuthenticateResponse authenticateResponse = (AuthenticateResponse)ServerUtil.jsonMapperWithWrapRoot().readValue(authenticateResponseString, AuthenticateResponse.class);
            String requestId = authenticateResponse.getRequestId();
            AuthenticateRequestMessageLdap authenticateRequestMessageLdap = this.u2fAuthenticationService.getAuthenticationRequestMessageByRequestId(requestId);
            if (authenticateRequestMessageLdap == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SESSION_EXPIRED)).build());
            }
            sessionState = authenticateRequestMessageLdap.getSessionState();
            this.u2fAuthenticationService.removeAuthenticationRequestMessage(authenticateRequestMessageLdap);
            AuthenticateRequestMessage authenticateRequestMessage = authenticateRequestMessageLdap.getAuthenticateRequestMessage();
            String foundUserInum = authenticateRequestMessageLdap.getUserInum();
            DeviceRegistration deviceRegistration = this.u2fAuthenticationService.finishAuthentication(authenticateRequestMessage, authenticateResponse, foundUserInum);
            if (StringHelper.isNotEmpty((String)sessionState)) {
                this.log.debug((Object)"There is session state. Setting session state attributes", new Object[0]);
                boolean oneStep = StringHelper.isEmpty((String)userName);
                this.userSessionStateService.updateUserSessionStateOnFinishRequest(sessionState, foundUserInum, deviceRegistration, false, oneStep);
            }
            AuthenticateStatus authenticationStatus = new AuthenticateStatus("success", requestId);
            String entity = ServerUtil.asJson(authenticationStatus);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            try {
                if (StringHelper.isNotEmpty(sessionState)) {
                    this.log.debug((Object)"There is session state. Setting session state status to 'declined'", new Object[0]);
                    this.userSessionStateService.updateUserSessionStateOnError(sessionState);
                }
            }
            catch (Exception ex2) {
                this.log.error((Object)"Failed to update session state status", (Throwable)ex2, new Object[0]);
            }
            if (ex instanceof BadInputException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.INVALID_REQUEST)).build());
            }
            if (ex instanceof DeviceCompromisedException) {
                DeviceRegistration deviceRegistration = ((DeviceCompromisedException)ex).getDeviceRegistration();
                try {
                    this.deviceRegistrationService.disableUserDeviceRegistration(deviceRegistration);
                }
                catch (Exception ex2) {
                    this.log.error((Object)"Failed to mark device '{0}' as compomised", (Throwable)ex2, new Object[]{deviceRegistration.getId()});
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.DEVICE_COMPROMISED)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }
}

