/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.PermissionTicket;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.UmaPermission;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;
import org.xdi.oxauth.service.uma.UmaValidationService;

@Name(value="resourceSetPermissionRegistrationRestWebService")
@Path(value="/host/rsrc_pr")
@Api(value="/host/rsrc_pr", description="The resource server uses the protection API's permission registration endpoint to register a requested permission with the authorization server that would suffice for the client's access attempt. The authorization server returns a permission ticket for the resource server to give to the client in its response. The PAT provided in the API request implicitly identifies the resource owner (\"subject\") to which the permission applies.\n\nNote: The resource server is free to choose the extent of the requested permission that it registers, as long as it minimally suffices for the access attempted by the client. For example, it can choose to register a permission that covers several scopes or a resource set that is greater in extent than the specific resource that the client attempted to access. Likewise, the authorization server is ultimately free to choose to partially fulfill the elements of a permission request based on incomplete satisfaction of policy criteria, or not to fulfill the request.\n\nThe resource server uses the POST method at the endpoint. The body of the HTTP request message contains a JSON object providing the requested permission, using a format derived from the scope description format specified in [OAuth-resource-reg], as follows. The object has the following properties:")
public class PermissionRegistrationWS {
    public static final int DEFAULT_PERMISSION_LIFETIME = 3600;
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private UmaValidationService umaValidationService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Registers permission using the POST method", consumes="application/json", produces="application/json", notes="The resource server uses the POST method at the endpoint. The body of the HTTP request message contains a JSON object providing the requested permission, using a format derived from the scope description format specified in [OAuth-resource-reg], as follows. The object has the following properties:")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=400, message="Bad Request")})
    public Response registerResourceSetPermission(@Context HttpServletRequest request, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Host") String amHost, @ApiParam(value="The identifier for a resource set to which this client is seeking access. The identifier MUST correspond to a resource set that was previously registered.", required=true) UmaPermission resourceSetPermissionRequest) {
        try {
            this.umaValidationService.assertHasProtectionScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            this.umaValidationService.validateResourceSet(resourceSetPermissionRequest);
            ResourceSetPermission resourceSetPermissions = this.resourceSetPermissionManager.createResourceSetPermission(validatedAmHost, resourceSetPermissionRequest, PermissionRegistrationWS.rptExpirationDate());
            this.resourceSetPermissionManager.addResourceSetPermission(resourceSetPermissions, this.tokenService.getClientDn(authorization));
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new PermissionTicket(resourceSetPermissions.getTicket())).build();
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    public static Date rptExpirationDate() {
        int lifeTime = ConfigurationFactory.instance().getConfiguration().getUmaRequesterPermissionTokenLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }
}

