/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.model.token.JwtSigner;
import org.xdi.oxauth.model.uma.GatRequest;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.service.uma.authorization.AuthorizationService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.security.StringEncrypter;

@Path(value="/requester")
@Api(value="/requester/rpt", description="The endpoint at which the requester asks the AM to issue an RPT")
@Name(value="rptRestWebService")
public class CreateRptWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RPTManager rptManager;
    @In
    private UmaValidationService umaValidationService;
    @In
    private TokenService tokenService;
    @In
    private AuthorizationService umaAuthorizationService;
    @In
    private LdapEntryManager ldapEntryManager;

    @Path(value="rpt")
    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="The endpoint at which the requester asks the AM to issue an RPT", produces="application/json", notes="The endpoint at which the requester asks the AM to issue an RPT")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response getRpt(@HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Host") String amHost) {
        try {
            this.umaValidationService.assertHasAuthorizationScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            UmaRPT rpt = this.rptManager.createRPT(authorization, validatedAmHost, false);
            String rptResponse = rpt.getCode();
            Boolean umaRptAsJwt = ConfigurationFactory.instance().getConfiguration().getUmaRptAsJwt();
            if (umaRptAsJwt != null && umaRptAsJwt.booleanValue()) {
                rptResponse = this.createJwr(rpt, authorization, Lists.newArrayList()).asString();
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ServerUtil.asJson(new RPTResponse(rptResponse))).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private JsonWebResponse createJwr(UmaRPT rpt, String authorization, List<String> gluuAccessTokenScopes) throws SignatureException, StringEncrypter.EncryptionException, InvalidJwtException, InvalidJweException, InvalidClaimException {
        AuthorizationGrant grant = this.tokenService.getAuthorizationGrant(authorization);
        JwtSigner jwtSigner = new JwtSigner(grant.getClient());
        Jwt jwt = jwtSigner.newJwt();
        jwt.getClaims().setExpirationTime(rpt.getExpirationDate());
        jwt.getClaims().setIssuedAt(rpt.getCreationDate());
        if (!gluuAccessTokenScopes.isEmpty()) {
            jwt.getClaims().setClaim("scopes", gluuAccessTokenScopes);
        }
        return jwtSigner.sign();
    }

    @Path(value="gat")
    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="The endpoint at which the requester asks the AM to issue an GAT", produces="application/json", notes="The endpoint at which the requester asks the AM to issue an GAT")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response getGat(@HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Host") String amHost, GatRequest request, @Context HttpServletRequest httpRequest) {
        try {
            this.umaValidationService.assertHasAuthorizationScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            UmaRPT rpt = this.rptManager.createRPT(authorization, validatedAmHost, true);
            this.authorizeGat(request, rpt, authorization, httpRequest);
            String rptResponse = rpt.getCode();
            Boolean umaRptAsJwt = ConfigurationFactory.instance().getConfiguration().getUmaRptAsJwt();
            if (umaRptAsJwt != null && umaRptAsJwt.booleanValue()) {
                rptResponse = this.createJwr(rpt, authorization, request.getScopes()).asString();
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ServerUtil.asJson(new RPTResponse(rptResponse))).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private void authorizeGat(GatRequest request, UmaRPT rpt, String authorization, HttpServletRequest httpRequest) {
        if (request.getScopes().isEmpty()) {
            return;
        }
        AuthorizationGrant grant = this.tokenService.getAuthorizationGrant(authorization);
        if (this.umaAuthorizationService.allowToAddPermissionForGat(grant, rpt, request.getScopes(), httpRequest, request.getClaims())) {
            ArrayList<String> scopes = new ArrayList<String>();
            if (rpt.getPermissions() != null) {
                scopes.addAll(rpt.getPermissions());
            }
            scopes.addAll(request.getScopes());
            rpt.setPermissions(scopes);
            try {
                this.ldapEntryManager.merge((Object)rpt);
                return;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
    }
}

