/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.token.ws.rs;

import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.token.ValidateTokenErrorResponseType;
import org.xdi.oxauth.model.token.ValidateTokenParamsValidator;
import org.xdi.oxauth.token.ws.rs.ValidateTokenRestWebService;

@Name(value="requestValidateTokenRestWebService")
public class ValidateTokenRestWebServiceImpl
implements ValidateTokenRestWebService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;

    @Override
    public Response validateAccessTokenGet(String accessToken, SecurityContext sec) {
        return this.validateAccessToken(accessToken, sec);
    }

    @Override
    public Response validateAccessTokenPost(String accessToken, SecurityContext sec) {
        return this.validateAccessToken(accessToken, sec);
    }

    private Response validateAccessToken(String accessToken, SecurityContext sec) {
        this.log.debug((Object)"Attempting to validate access token: {0}, Is Secure = {1}", new Object[]{accessToken, sec.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        try {
            if (!ValidateTokenParamsValidator.validateParams(accessToken)) {
                builder = Response.status((int)400);
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)ValidateTokenErrorResponseType.INVALID_REQUEST));
            } else {
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
                if (authorizationGrant != null) {
                    AbstractToken token = authorizationGrant.getAccessToken(accessToken);
                    boolean valid = token.isValid();
                    int expiresIn = token.getExpiresIn();
                    CacheControl cacheControl = new CacheControl();
                    cacheControl.setPrivate(true);
                    cacheControl.setNoTransform(false);
                    cacheControl.setNoStore(true);
                    builder.cacheControl(cacheControl);
                    builder.header("Pragma", (Object)"no-cache");
                    builder.entity((Object)this.getJSonResponse(valid, expiresIn));
                } else {
                    builder = Response.status((int)401);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)ValidateTokenErrorResponseType.INVALID_GRANT));
                }
            }
        }
        catch (Exception e) {
            builder = Response.status((int)500);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return builder.build();
    }

    public String getJSonResponse(boolean valid, Integer expiresIn) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("valid", valid);
            if (expiresIn != null) {
                jsonObj.put("expires_in", (Object)expiresIn);
            }
        }
        catch (JSONException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return jsonObj.toString();
    }
}

