/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.session.ws.rs;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.session.EndSessionParamsValidator;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.RedirectionUriService;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.oxauth.service.external.ExternalApplicationSessionService;
import org.xdi.oxauth.session.ws.rs.EndSessionRestWebService;
import org.xdi.oxauth.util.RedirectUri;
import org.xdi.oxauth.util.RedirectUtil;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.Pair;
import org.xdi.util.StringHelper;

@Name(value="endSessionRestWebService")
public class EndSessionRestWebServiceImpl
implements EndSessionRestWebService {
    private static final boolean HTTP_BASED = true;
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RedirectionUriService redirectionUriService;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ExternalApplicationSessionService externalApplicationSessionService;
    @In
    private SessionStateService sessionStateService;
    @In
    private ClientService clientService;
    @In(required=false)
    private Identity identity;

    @Override
    public Response requestEndSession(String idTokenHint, String postLogoutRedirectUri, String state, String sessionState, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext sec) {
        this.log.debug((Object)"Attempting to end session, idTokenHint: {0}, postLogoutRedirectUri: {1}, sessionState: {2}, Is Secure = {3}", new Object[]{idTokenHint, postLogoutRedirectUri, sessionState, sec.isSecure()});
        EndSessionParamsValidator.validateParams(idTokenHint, this.errorResponseFactory);
        Pair<SessionState, AuthorizationGrant> pair = this.endSession(idTokenHint, sessionState, httpRequest, httpResponse, sec);
        return this.httpBased(postLogoutRedirectUri, state, pair);
    }

    public Response httpBased(String postLogoutRedirectUri, String state, Pair<SessionState, AuthorizationGrant> pair) {
        String redirectUri = this.redirectionUriService.validatePostLogoutRedirectUri(((AuthorizationGrant)pair.getSecond()).getClient().getClientId(), postLogoutRedirectUri);
        Set<String> logoutUris = this.getRpLogoutUris(pair);
        String html = this.constructPage(logoutUris, redirectUri, state);
        this.log.debug((Object)("Constructed http logout page: " + html), new Object[0]);
        return Response.ok().cacheControl(ServerUtil.cacheControl(true, true)).header("Pragma", (Object)"no-cache").type(MediaType.TEXT_HTML_TYPE).entity((Object)html).build();
    }

    private Response simpleLogout(String postLogoutRedirectUri, String state, HttpServletRequest httpRequest, Pair<SessionState, AuthorizationGrant> pair) {
        if (!Util.isNullOrEmpty((String)postLogoutRedirectUri)) {
            String redirectUri = this.redirectionUriService.validatePostLogoutRedirectUri(((AuthorizationGrant)pair.getSecond()).getClient().getClientId(), postLogoutRedirectUri);
            if (StringUtils.isNotBlank((String)redirectUri)) {
                RedirectUri redirectUriResponse = new RedirectUri(redirectUri);
                if (StringUtils.isNotBlank((String)state)) {
                    redirectUriResponse.addResponseParameter("state", state);
                }
                return RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest).build();
            }
            this.errorResponseFactory.throwBadRequestException((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST);
        }
        return Response.ok().cacheControl(ServerUtil.cacheControl(true, true)).header("Pragma", (Object)"no-cache").build();
    }

    private Pair<SessionState, AuthorizationGrant> endSession(String idTokenHint, String sessionState, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext sec) {
        boolean isGrantAndExternalLogoutSuccessful;
        EndSessionParamsValidator.validateParams(idTokenHint, this.errorResponseFactory);
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant == null) {
            this.log.info((Object)"Failed to find out authorization grant for id_token_hint '{0}'", new Object[]{idTokenHint});
            this.errorResponseFactory.throwUnauthorizedException((IErrorType)EndSessionErrorResponseType.INVALID_GRANT);
        }
        boolean externalLogoutResult = false;
        SessionState ldapSessionState = this.removeSessionState(sessionState, httpRequest, httpResponse);
        boolean isExternalLogoutPresent = this.externalApplicationSessionService.isEnabled();
        if (isExternalLogoutPresent) {
            externalLogoutResult = this.externalApplicationSessionService.executeExternalEndSessionMethods(httpRequest, authorizationGrant);
            this.log.info((Object)"End session result for '{0}': '{1}'", new Object[]{authorizationGrant.getUser().getUserId(), "logout", externalLogoutResult});
        }
        boolean bl = isGrantAndExternalLogoutSuccessful = isExternalLogoutPresent && externalLogoutResult;
        if (isExternalLogoutPresent && !isGrantAndExternalLogoutSuccessful) {
            this.errorResponseFactory.throwUnauthorizedException((IErrorType)EndSessionErrorResponseType.INVALID_GRANT);
        }
        authorizationGrant.revokeAllTokens();
        if (this.identity != null) {
            this.identity.logout();
        }
        return new Pair((Object)ldapSessionState, (Object)authorizationGrant);
    }

    private Set<String> getRpLogoutUris(Pair<SessionState, AuthorizationGrant> pair) {
        HashSet result = Sets.newHashSet();
        SessionState sessionState = (SessionState)pair.getFirst();
        if (sessionState == null) {
            this.log.error((Object)"session_state is not passed to endpoint (as cookie or manually). Therefore unable to match clients for session_state.Http based html will contain no iframes.", new Object[0]);
            return result;
        }
        HashSet clientsByDns = sessionState.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionState.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        clientsByDns.add(((AuthorizationGrant)pair.getSecond()).getClient());
        for (Client client : clientsByDns) {
            String logoutUri = client.getLogoutUri();
            if (Util.isNullOrEmpty((String)logoutUri)) continue;
            if (client.getLogoutSessionRequired() != null && client.getLogoutSessionRequired().booleanValue()) {
                logoutUri = logoutUri.contains("?") ? logoutUri + "&sid=" + sessionState.getId() : logoutUri + "?sid=" + sessionState.getId();
            }
            result.add(logoutUri);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionState removeSessionState(String sessionState, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        SessionState ldapSessionState = null;
        try {
            String id = sessionState;
            if (StringHelper.isEmpty((String)id)) {
                id = this.sessionStateService.getSessionStateFromCookie(httpRequest);
            }
            if (StringHelper.isNotEmpty((String)id)) {
                ldapSessionState = this.sessionStateService.getSessionState(id);
                if (ldapSessionState != null) {
                    boolean result = this.sessionStateService.remove(ldapSessionState);
                    if (!result) {
                        this.log.error((Object)"Failed to remove session_state '{0}' from LDAP", new Object[]{id});
                    }
                } else {
                    this.log.error((Object)"Failed to load session from LDAP by session_state: '{0}'", new Object[]{id});
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            this.sessionStateService.removeSessionStateCookie(httpResponse);
        }
        return ldapSessionState;
    }

    private String constructPage(Set<String> logoutUris, String postLogoutUrl, String state) {
        String iframes = "";
        for (String logoutUri : logoutUris) {
            iframes = iframes + String.format("<iframe height=\"0\" width=\"0\" src=\"%s\"></iframe>", logoutUri);
        }
        String html = "<!DOCTYPE html><html><head>";
        if (!Util.isNullOrEmpty((String)postLogoutUrl)) {
            if (!Util.isNullOrEmpty((String)state)) {
                postLogoutUrl = postLogoutUrl.contains("?") ? postLogoutUrl + "&state=" + state : postLogoutUrl + "?state=" + state;
            }
            html = html + "<script>window.onload=function() {window.location='" + postLogoutUrl + "'" + "}" + "</script>";
        }
        html = html + "<title>Gluu Generated logout page</title></head><body>Logout requests sent.<br/>" + iframes + "</body>" + "</html>";
        return html;
    }
}

