/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.session.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Path(value="/oxauth")
@Api(value="/oxauth", description="Check Session Status Endpoint")
@Name(value="checkSessionStatusRestWebService")
public class CheckSessionStatusRestWebServiceImpl {
    @Logger
    private Log log;
    @In
    private SessionStateService sessionStateService;
    @In(required=false)
    private Identity identity;

    @GET
    @Path(value="/session_status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Determine cussrent sesion status.", notes="Determine cussrent sesion status.", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=400, message="invalid_request\nThe request is missing a required parameter, includes an unsupported parameter or parameter value, repeats the same parameter, uses more than one method for including an access token, or is otherwise malformed.  The resource server SHOULD respond with the HTTP 400 (Bad Request) status code.")})
    public Response requestCheckSessionStatus(@Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse, @Context SecurityContext securityContext) throws IOException {
        String sessionStateCookie = this.sessionStateService.getSessionStateFromCookie(httpRequest);
        this.log.debug((Object)"Found session '{0}' cookie: '{1}'", new Object[]{"session_state", sessionStateCookie});
        CheckSessionResponse response = new CheckSessionResponse("unknown", "");
        SessionState sessionState = this.sessionStateService.getSessionState(sessionStateCookie);
        if (sessionState != null) {
            response.setState(sessionState.getState().getValue());
            response.setAuthTime(sessionState.getAuthenticationTime());
            String sessionCustomState = sessionState.getSessionAttributes().get("session_custom_state");
            if (StringHelper.isNotEmpty((String)sessionCustomState)) {
                response.setCustomState(sessionCustomState);
            }
        }
        String responseJson = ServerUtil.asJson(response);
        this.log.debug((Object)"Check session status response: '{0}'", new Object[]{responseJson});
        return Response.ok().type("application/json").entity((Object)responseJson).build();
    }

    class CheckSessionResponse {
        @JsonProperty(value="state")
        String state;
        @JsonProperty(value="custom_state")
        String customState;
        @JsonProperty(value="auth_time")
        Date authTime;

        public CheckSessionResponse(String state, String stateExt) {
            this.state = state;
            this.customState = stateExt;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getCustomState() {
            return this.customState;
        }

        public void setCustomState(String customState) {
            this.customState = customState;
        }

        public Date getAuthTime() {
            return this.authTime;
        }

        public void setAuthTime(Date authTime) {
            this.authTime = authTime;
        }
    }
}

