/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.service.SectorIdentifierService;
import org.xdi.oxauth.servlet.OpenIdConfiguration;

public class SectorIdentifier
extends HttpServlet {
    private static final Log LOG = Logging.getLog(OpenIdConfiguration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        try {
            String urlPath = request.getPathInfo();
            String inum = urlPath.substring(urlPath.lastIndexOf("/") + 1, urlPath.length());
            org.xdi.oxauth.model.ldap.SectorIdentifier sectorIdentifier = SectorIdentifierService.instance().getSectorIdentifierByInum(inum);
            JSONArray jsonArray = new JSONArray();
            for (String redirectUri : sectorIdentifier.getRedirectUris()) {
                jsonArray.put((Object)redirectUri);
            }
            out.println(jsonArray.toString(4).replace("\\/", "/"));
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Sector Identifier";
    }
}

