/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.uma.ClaimToken;
import org.xdi.oxauth.model.uma.ClaimTokenList;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.model.uma.persistence.ScopeDescription;
import org.xdi.oxauth.service.external.ExternalUmaAuthorizationPolicyService;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.authorization.AuthorizationContext;
import org.xdi.oxauth.service.uma.authorization.NeedInfoResponseBuilder;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaAuthorizationService")
@AutoCreate
public class AuthorizationService {
    @Logger
    private Log log;
    @In
    private ScopeService umaScopeService;
    @In
    private ExternalUmaAuthorizationPolicyService externalUmaAuthorizationPolicyService;

    public boolean allowToAddPermission(AuthorizationGrant grant, UmaRPT rpt, ResourceSetPermission permission, HttpServletRequest httpRequest, ClaimTokenList claims) {
        this.log.trace((Object)"Check policies for permission, id: '{0}'", new Object[]{permission.getDn()});
        List<ScopeDescription> scopes = this.umaScopeService.getScopesByDns(permission.getScopeDns());
        return this.allowToAddPermission(grant, rpt, scopes, permission, httpRequest, claims);
    }

    public boolean allowToAddPermissionForGat(AuthorizationGrant grant, UmaRPT rpt, List<String> scopes, HttpServletRequest httpRequest, ClaimTokenList claims) {
        List<ScopeDescription> scopesByUrls = this.umaScopeService.getScopesByUrls(scopes);
        return this.allowToAddPermission(grant, rpt, scopesByUrls, new ResourceSetPermission(), httpRequest, claims);
    }

    public boolean allowToAddPermission(AuthorizationGrant grant, UmaRPT rpt, List<ScopeDescription> scopes, ResourceSetPermission permission, HttpServletRequest httpRequest, ClaimTokenList claims) {
        this.log.trace((Object)"Check policies for scopes: '{0}'", new Object[]{scopes});
        Set<String> authorizationPolicies = this.getAuthorizationPolicies(scopes);
        if (authorizationPolicies == null || authorizationPolicies.isEmpty()) {
            this.log.trace((Object)"No policies protection, allowed to grant permission.", new Object[0]);
            return true;
        }
        UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(grant);
        AuthorizationContext context = new AuthorizationContext(rpt, permission, unmodifiableAuthorizationGrant, httpRequest, (List<ClaimToken>)claims);
        for (String authorizationPolicy : authorizationPolicies) {
            if (this.applyPolicy(authorizationPolicy, context)) continue;
            this.log.trace((Object)"Reject access. Policy dn: '{0}'", new Object[]{authorizationPolicy});
            return false;
        }
        this.log.trace((Object)"All policies are ok, grant access.", new Object[0]);
        return true;
    }

    private Set<String> getAuthorizationPolicies(List<ScopeDescription> scopes) {
        HashSet<String> result = new HashSet<String>();
        for (ScopeDescription scope : scopes) {
            List authorizationPolicies = scope.getAuthorizationPolicies();
            if (authorizationPolicies == null) continue;
            result.addAll(authorizationPolicies);
        }
        return result;
    }

    private boolean applyPolicy(String authorizationPolicyDn, AuthorizationContext authorizationContext) {
        this.log.trace((Object)"Apply policy dn: '{0}' ...", new Object[]{authorizationPolicyDn});
        CustomScriptConfiguration customScriptConfiguration = this.externalUmaAuthorizationPolicyService.getAuthorizationPolicyByDn(authorizationPolicyDn);
        if (customScriptConfiguration != null) {
            boolean result = this.externalUmaAuthorizationPolicyService.executeExternalAuthorizeMethod(customScriptConfiguration, authorizationContext);
            this.log.trace((Object)"Policy '{0}' result: {1}", new Object[]{authorizationPolicyDn, result});
            if (!(result || authorizationContext.getNeedInfoAuthenticationContext() == null && authorizationContext.getNeedInfoRequestingPartyClaims() == null)) {
                String jsonEntity = NeedInfoResponseBuilder.entityForResponse(authorizationContext.getNeedInfoAuthenticationContext(), authorizationContext.getNeedInfoRequestingPartyClaims());
                AuthorizationService.throwForbiddenException(jsonEntity);
            }
            return result;
        }
        this.log.error((Object)"Unable to load custom script dn: '{0}'", new Object[]{authorizationPolicyDn});
        return false;
    }

    private static void throwForbiddenException(String entity) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)entity).build());
    }

    public static AuthorizationService instance() {
        return (AuthorizationService)ServerUtil.instance(AuthorizationService.class);
    }
}

