/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.uma.ClaimToken;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.external.context.ExternalScriptContext;
import org.xdi.oxauth.service.uma.authorization.NeedInfoAuthenticationContext;
import org.xdi.oxauth.service.uma.authorization.NeedInfoRequestingPartyClaims;

public class AuthorizationContext
extends ExternalScriptContext {
    private final UmaRPT m_rpt;
    private final ResourceSetPermission m_permission;
    private final IAuthorizationGrant m_grant;
    private final Map<String, List<String>> m_claims;
    private NeedInfoAuthenticationContext needInfoAuthenticationContext;
    private NeedInfoRequestingPartyClaims needInfoRequestingPartyClaims;

    public AuthorizationContext(UmaRPT p_rpt, ResourceSetPermission p_permission, IAuthorizationGrant p_grant, HttpServletRequest p_httpRequest, List<ClaimToken> claims) {
        super(p_httpRequest);
        this.m_rpt = p_rpt;
        this.m_permission = p_permission;
        this.m_grant = p_grant;
        this.m_claims = new HashMap<String, List<String>>();
        if (claims != null) {
            for (ClaimToken claim : claims) {
                List<String> strings = this.m_claims.get(claim.getFormat());
                if (strings == null) {
                    strings = new ArrayList<String>();
                }
                strings.add(claim.getToken());
                this.m_claims.put(claim.getFormat(), strings);
            }
        }
    }

    public List<String> getRequestClaim(String p_claimName) {
        List<String> value;
        if (StringUtils.isNotBlank((String)p_claimName) && this.m_claims != null && (value = this.m_claims.get(p_claimName)) != null) {
            return Collections.unmodifiableList(value);
        }
        return Collections.emptyList();
    }

    public IAuthorizationGrant getGrant() {
        return this.m_grant;
    }

    public String getAcrs() {
        return this.m_grant.getAcrValues();
    }

    public String getClientClaim(String p_claimName) {
        return this.getEntryAttributeValue(this.getGrant().getClientDn(), p_claimName);
    }

    public String getUserClaim(String p_claimName) {
        GluuAttribute gluuAttribute = AttributeService.instance().getByClaimName(p_claimName);
        if (gluuAttribute != null) {
            String ldapClaimName = gluuAttribute.getName();
            return this.getEntryAttributeValue(this.getGrant().getUserDn(), ldapClaimName);
        }
        return null;
    }

    public String getUserClaimByLdapName(String p_ldapName) {
        return this.getEntryAttributeValue(this.getGrant().getUserDn(), p_ldapName);
    }

    public UmaRPT getRpt() {
        return this.m_rpt;
    }

    public ResourceSetPermission getPermission() {
        return this.m_permission;
    }

    public NeedInfoAuthenticationContext getNeedInfoAuthenticationContext() {
        return this.needInfoAuthenticationContext;
    }

    public void setNeedInfoAuthenticationContext(NeedInfoAuthenticationContext needInfoAuthenticationContext) {
        this.needInfoAuthenticationContext = needInfoAuthenticationContext;
    }

    public NeedInfoRequestingPartyClaims getNeedInfoRequestingPartyClaims() {
        return this.needInfoRequestingPartyClaims;
    }

    public void setNeedInfoRequestingPartyClaims(NeedInfoRequestingPartyClaims needInfoRequestingPartyClaims) {
        this.needInfoRequestingPartyClaims = needInfoRequestingPartyClaims;
    }
}

