/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.AbstractResourceSetPermissionManager;

public class ResourceSetPermissionManagerInMemory
extends AbstractResourceSetPermissionManager
implements Serializable {
    private static final long serialVersionUID = -3993184173686369535L;
    private ConcurrentHashMap<String, ResourceSetPermission> resourceSetPermissions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> ticketToConfigurationCodeMapping = new ConcurrentHashMap();

    @Override
    public void addResourceSetPermission(ResourceSetPermission resourceSetPermission, String clientDn) {
        String resourceSetPermissionTicket = resourceSetPermission.getTicket();
        this.resourceSetPermissions.put(resourceSetPermissionTicket, resourceSetPermission);
        this.ticketToConfigurationCodeMapping.put(resourceSetPermission.getConfigurationCode(), resourceSetPermissionTicket);
    }

    @Override
    public ResourceSetPermission getResourceSetPermissionByTicket(String resourceSetPermissionTicket) {
        return this.resourceSetPermissions.get(resourceSetPermissionTicket);
    }

    @Override
    public String getResourceSetPermissionTicketByConfigurationCode(String configurationCode, String clientDn) {
        return this.ticketToConfigurationCodeMapping.get(configurationCode);
    }

    @Override
    public void deleteResourceSetPermission(String resourceSetPermissionTicket) {
        if (!this.resourceSetPermissions.containsKey(resourceSetPermissionTicket)) {
            return;
        }
        ResourceSetPermission resourceSetPermission = this.resourceSetPermissions.get(resourceSetPermissionTicket);
        this.resourceSetPermissions.remove(resourceSetPermissionTicket);
        this.ticketToConfigurationCodeMapping.remove(resourceSetPermission.getConfigurationCode());
    }

    @Override
    public void cleanupResourceSetPermissions(Date now) {
        Iterator<Map.Entry<String, ResourceSetPermission>> it = this.resourceSetPermissions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ResourceSetPermission> resourceSetPermissionEntry = it.next();
            ResourceSetPermission resourceSetPermission = resourceSetPermissionEntry.getValue();
            resourceSetPermission.checkExpired(now);
            if (resourceSetPermission.isValid()) continue;
            it.remove();
            this.ticketToConfigurationCodeMapping.remove(resourceSetPermission.getConfigurationCode());
        }
    }
}

