/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import java.util.Date;
import java.util.UUID;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.service.uma.IRPTManager;
import org.xdi.util.INumGenerator;

public abstract class AbstractRPTManager
implements IRPTManager {
    private static final Log LOG = Logging.getLog(AbstractRPTManager.class);
    private static final String GAT_MARKER = "gat_";

    @Override
    public UmaRPT createRPT(IAuthorizationGrant grant, String amHost, String aat, boolean isGat) {
        AccessToken accessToken = (AccessToken)grant.getAccessToken(aat);
        try {
            String code = UUID.randomUUID().toString() + "/" + INumGenerator.generate((int)8);
            if (isGat) {
                code = GAT_MARKER + code;
            }
            return new UmaRPT(code, new Date(), accessToken.getExpirationDate(), grant.getUserId(), grant.getClientId(), amHost);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            throw new RuntimeException("Failed to generate RPT, aat: " + aat, e);
        }
    }

    public static boolean isGat(String rptCode) {
        return rptCode.startsWith(GAT_MARKER);
    }
}

