/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="userSessionStateService")
@AutoCreate
public class UserSessionStateService {
    @Logger
    private Log log;
    @In
    private SessionStateService sessionStateService;

    public void updateUserSessionStateOnFinishRequest(String sessionState, String userInum, DeviceRegistration deviceRegistration, boolean enroll, boolean oneStep) {
        SessionState ldapSessionState = this.getLdapSessionState(sessionState);
        if (ldapSessionState == null) {
            return;
        }
        Map<String, String> sessionAttributes = ldapSessionState.getSessionAttributes();
        sessionAttributes.put("session_custom_state", "approved");
        sessionAttributes.put("oxpush2_u2f_device_id", deviceRegistration.getId());
        sessionAttributes.put("oxpush2_u2f_device_user_inum", userInum);
        sessionAttributes.put("oxpush2_u2f_device_enroll", Boolean.toString(enroll));
        sessionAttributes.put("oxpush2_u2f_device_one_step", Boolean.toString(oneStep));
        this.sessionStateService.updateSessionState(ldapSessionState, true);
    }

    public void updateUserSessionStateOnError(String sessionState) {
        SessionState ldapSessionState = this.getLdapSessionState(sessionState);
        if (ldapSessionState == null) {
            return;
        }
        Map<String, String> sessionAttributes = ldapSessionState.getSessionAttributes();
        sessionAttributes.put("session_custom_state", "declined");
        this.sessionStateService.updateSessionState(ldapSessionState, true);
    }

    private SessionState getLdapSessionState(String sessionState) {
        if (StringHelper.isEmpty((String)sessionState)) {
            return null;
        }
        SessionState ldapSessionState = this.sessionStateService.getSessionState(sessionState);
        if (ldapSessionState == null) {
            this.log.warn((Object)"Failed to load session state '{0}'", new Object[]{sessionState});
            return null;
        }
        if (SessionIdState.UNAUTHENTICATED != ldapSessionState.getState()) {
            this.log.warn((Object)"Unexpected session '{0}' state: '{1}'", new Object[]{sessionState, ldapSessionState.getState()});
            return null;
        }
        return ldapSessionState;
    }
}

