/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import org.apache.commons.io.IOUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.crypto.cert.CertificateParser;
import org.xdi.oxauth.crypto.signature.SHA256withECDSASignatureVerification;
import org.xdi.oxauth.model.exception.SignatureException;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.message.RawRegisterResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.util.io.ByteDataInputStream;

@Scope(value=ScopeType.STATELESS)
@Name(value="rawRegistrationService")
@AutoCreate
public class RawRegistrationService {
    public static final byte REGISTRATION_RESERVED_BYTE_VALUE = 5;
    public static final byte REGISTRATION_SIGNED_RESERVED_BYTE_VALUE = 0;
    public static final long INITIAL_DEVICE_COUNTER_VALUE = -1L;
    public static final String REGISTER_TYPE = "navigator.id.finishEnrollment";
    @Logger
    private Log log;
    @In(value="sha256withECDSASignatureVerification")
    private SHA256withECDSASignatureVerification signatureVerification;

    public RawRegisterResponse parseRawRegisterResponse(String rawDataBase64) throws BadInputException {
        ByteDataInputStream bis = new ByteDataInputStream(Base64Util.base64urldecode((String)rawDataBase64));
        try {
            byte reservedByte = bis.readSigned();
            if (reservedByte != 5) {
                throw new BadInputException("Incorrect value of reserved byte. Expected: 5. Was: " + reservedByte);
            }
            RawRegisterResponse rawRegisterResponse = new RawRegisterResponse(bis.read(65), bis.read(bis.readUnsigned()), CertificateParser.parseDer((InputStream)bis), bis.readAll());
            return rawRegisterResponse;
        }
        catch (IOException ex) {
            throw new BadInputException("Failed to parse RAW register response", (Throwable)ex);
        }
        catch (CertificateException e) {
            throw new BadInputException("Malformed attestation certificate", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public void checkSignature(String appId, ClientData clientData, RawRegisterResponse rawRegisterResponse) throws BadInputException {
        String rawClientData = clientData.getRawClientData();
        byte[] signedBytes = this.packBytesToSign(this.signatureVerification.hash(appId), this.signatureVerification.hash(rawClientData), rawRegisterResponse.getKeyHandle(), rawRegisterResponse.getUserPublicKey());
        try {
            this.signatureVerification.checkSignature(rawRegisterResponse.getAttestationCertificate(), signedBytes, rawRegisterResponse.getSignature());
        }
        catch (SignatureException ex) {
            throw new BadInputException("Failed to checkSignature", (Throwable)ex);
        }
    }

    private byte[] packBytesToSign(byte[] appIdHash, byte[] clientDataHash, byte[] keyHandle, byte[] userPublicKey) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(0);
        encoded.write(appIdHash);
        encoded.write(clientDataHash);
        encoded.write(keyHandle);
        encoded.write(userPublicKey);
        return encoded.toByteArray();
    }

    public DeviceRegistration createDevice(RawRegisterResponse rawRegisterResponse) throws BadInputException {
        return new DeviceRegistration(Base64Util.base64urlencode((byte[])rawRegisterResponse.getKeyHandle()), Base64Util.base64urlencode((byte[])rawRegisterResponse.getUserPublicKey()), rawRegisterResponse.getAttestationCertificate(), -1L);
    }
}

