/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.service.UserService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="deviceRegistrationService")
@AutoCreate
public class DeviceRegistrationService {
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private UserService userService;
    @Logger
    private Log log;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("u2f_devices");
        branch.setDn(this.getBaseDnForU2fUserDevices(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getBaseDnForU2fUserDevices(userInum));
    }

    public void prepareBranch(String userInum) {
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public DeviceRegistration findUserDeviceRegistration(String userInum, String deviceId, String ... returnAttributes) {
        this.prepareBranch(userInum);
        String deviceDn = this.getDnForU2fDevice(userInum, deviceId);
        return (DeviceRegistration)this.ldapEntryManager.find(DeviceRegistration.class, (Object)deviceDn);
    }

    public List<DeviceRegistration> findUserDeviceRegistrations(String userInum, String appId, String ... returnAttributes) {
        this.prepareBranch(userInum);
        String baseDnForU2fDevices = this.getBaseDnForU2fUserDevices(userInum);
        Filter appIdFilter = Filter.createEqualityFilter((String)"oxApplication", (String)appId);
        return this.ldapEntryManager.findEntries(baseDnForU2fDevices, DeviceRegistration.class, returnAttributes, appIdFilter);
    }

    public List<DeviceRegistration> findDeviceRegistrationsByKeyHandle(String appId, String keyHandle, String ... returnAttributes) {
        if (StringHelper.isEmpty((String)appId) || org.hibernate.annotations.common.util.StringHelper.isEmpty((String)keyHandle)) {
            return new ArrayList<DeviceRegistration>(0);
        }
        byte[] keyHandleDecoded = Base64Util.base64urldecode((String)keyHandle);
        String baseDn = this.userService.getDnForUser(null);
        Filter deviceObjectClassFilter = Filter.createEqualityFilter((String)"objectClass", (String)"oxDeviceRegistration");
        Filter deviceHashCodeFilter = Filter.createEqualityFilter((String)"oxDeviceHashCode", (String)String.valueOf(this.getKeyHandleHashCode(keyHandleDecoded)));
        Filter deviceKeyHandleFilter = Filter.createEqualityFilter((String)"oxDeviceKeyHandle", (String)keyHandle);
        Filter appIdFilter = Filter.createEqualityFilter((String)"oxApplication", (String)appId);
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{deviceObjectClassFilter, deviceHashCodeFilter, appIdFilter, deviceKeyHandleFilter});
        return this.ldapEntryManager.findEntries(baseDn, DeviceRegistration.class, returnAttributes, filter);
    }

    public DeviceRegistration findOneStepUserDeviceRegistration(String deviceId, String ... returnAttributes) {
        String deviceDn = this.getDnForOneStepU2fDevice(deviceId);
        return (DeviceRegistration)this.ldapEntryManager.find(DeviceRegistration.class, (Object)deviceDn);
    }

    public void addUserDeviceRegistration(String userInum, DeviceRegistration deviceRegistration) {
        this.prepareBranch(userInum);
        this.ldapEntryManager.persist((Object)deviceRegistration);
    }

    public boolean attachUserDeviceRegistration(String userInum, String oneStepDeviceId) {
        String oneStepDeviceDn = this.getDnForOneStepU2fDevice(oneStepDeviceId);
        DeviceRegistration deviceRegistration = (DeviceRegistration)this.ldapEntryManager.find(DeviceRegistration.class, (Object)oneStepDeviceDn);
        if (deviceRegistration == null) {
            return false;
        }
        this.removeUserDeviceRegistration(deviceRegistration);
        String deviceDn = this.getDnForU2fDevice(userInum, deviceRegistration.getId());
        deviceRegistration.setDn(deviceDn);
        this.addUserDeviceRegistration(userInum, deviceRegistration);
        return true;
    }

    public void addOneStepDeviceRegistration(DeviceRegistration deviceRegistration) {
        this.ldapEntryManager.persist((Object)deviceRegistration);
    }

    public void updateDeviceRegistration(String userInum, DeviceRegistration deviceRegistration) {
        this.prepareBranch(userInum);
        this.ldapEntryManager.merge((Object)deviceRegistration);
    }

    public void disableUserDeviceRegistration(DeviceRegistration deviceRegistration) {
        deviceRegistration.setStatus(DeviceRegistrationStatus.COMPROMISED);
        this.ldapEntryManager.merge((Object)deviceRegistration);
    }

    public void removeUserDeviceRegistration(DeviceRegistration deviceRegistration) {
        this.ldapEntryManager.remove((Object)deviceRegistration);
    }

    public List<DeviceRegistration> getExpiredDeviceRegistrations(Date expirationDate) {
        String u2fBaseDn = this.getDnForOneStepU2fDevice(null);
        Filter expirationFilter = Filter.createLessOrEqualFilter((String)"creationDate", (String)this.ldapEntryManager.encodeGeneralizedTime(expirationDate));
        List deviceRegistrations = this.ldapEntryManager.findEntries(u2fBaseDn, DeviceRegistration.class, expirationFilter);
        return deviceRegistrations;
    }

    public String getDnForU2fDevice(String userInum, String oxId) {
        String baseDnForU2fDevices = this.getBaseDnForU2fUserDevices(userInum);
        if (org.hibernate.annotations.common.util.StringHelper.isEmpty((String)oxId)) {
            return baseDnForU2fDevices;
        }
        return String.format("oxId=%s,%s", oxId, baseDnForU2fDevices);
    }

    public String getBaseDnForU2fUserDevices(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=u2f_devices,%s", userBaseDn);
    }

    public String getDnForOneStepU2fDevice(String deviceRegistrationId) {
        String u2fBaseDn = ConfigurationFactory.instance().getBaseDn().getU2fBase();
        if (org.hibernate.annotations.common.util.StringHelper.isEmpty((String)deviceRegistrationId)) {
            return String.format("ou=registered_devices,%s", u2fBaseDn);
        }
        return String.format("oxid=%s,ou=registered_devices,%s", deviceRegistrationId, u2fBaseDn);
    }

    public int getKeyHandleHashCode(byte[] keyHandle) {
        int hash = 0;
        for (int j = 0; j < keyHandle.length; ++j) {
            hash += keyHandle[j] * j;
        }
        return hash;
    }

    public static DeviceRegistrationService instance() {
        return (DeviceRegistrationService)Component.getInstance(DeviceRegistrationService.class);
    }
}

