/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.type.uma.AuthorizationPolicyType;
import org.xdi.oxauth.service.uma.authorization.AuthorizationContext;
import org.xdi.service.LookupService;
import org.xdi.service.custom.script.ExternalScriptService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="externalUmaAuthorizationPolicyService")
@AutoCreate
@Startup
public class ExternalUmaAuthorizationPolicyService
extends ExternalScriptService {
    private static final long serialVersionUID = -8609727759114795432L;
    @In
    private LookupService lookupService;
    protected Map<String, CustomScriptConfiguration> customScriptConfigurationsInumMap;

    public ExternalUmaAuthorizationPolicyService() {
        super(CustomScriptType.UMA_AUTHORIZATION_POLICY);
    }

    protected void reloadExternal() {
        this.customScriptConfigurationsInumMap = this.buildExternalConfigurationsInumMap(this.customScriptConfigurations);
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsInumMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(customScriptConfiguration.getInum(), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration getAuthorizationPolicyByDn(String authorizationPolicyDn) {
        String authorizationPolicyInum = this.lookupService.getInumFromDn(authorizationPolicyDn);
        return this.getCustomScriptConfigurationByInum(authorizationPolicyInum);
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByInum(String inum) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        return this.customScriptConfigurationsInumMap.get(inum);
    }

    public boolean executeExternalAuthorizeMethod(CustomScriptConfiguration customScriptConfiguration, AuthorizationContext authorizationContext) {
        try {
            this.log.debug((Object)"Executing python 'authorize' method", new Object[0]);
            AuthorizationPolicyType externalType = (AuthorizationPolicyType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.authorize((Object)authorizationContext, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public static ExternalUmaAuthorizationPolicyService instance() {
        return (ExternalUmaAuthorizationPolicyService)((Object)Component.getInstance(ExternalUmaAuthorizationPolicyService.class));
    }
}

