/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.model.CustomScript;
import org.xdi.model.custom.script.model.auth.AuthenticationCustomScript;
import org.xdi.model.custom.script.type.BaseExternalType;
import org.xdi.model.custom.script.type.auth.PersonAuthenticationType;
import org.xdi.oxauth.service.external.internal.InternalDefaultPersonAuthenticationType;
import org.xdi.service.custom.script.ExternalScriptService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="externalAuthenticationService")
@AutoCreate
@Startup
public class ExternalAuthenticationService
extends ExternalScriptService {
    private static final long serialVersionUID = 7339887464253044927L;
    private final CustomScriptConfiguration internalCustomScriptConfiguration;
    private Map<AuthenticationScriptUsageType, List<CustomScriptConfiguration>> customScriptConfigurationsMapByUsageType;
    private Map<AuthenticationScriptUsageType, CustomScriptConfiguration> defaultExternalAuthenticators;

    public ExternalAuthenticationService() {
        super(CustomScriptType.PERSON_AUTHENTICATION);
        InternalDefaultPersonAuthenticationType personAuthenticationType = new InternalDefaultPersonAuthenticationType();
        AuthenticationCustomScript customScript = new AuthenticationCustomScript(){

            public AuthenticationScriptUsageType getUsageType() {
                return AuthenticationScriptUsageType.INTERACTIVE;
            }
        };
        customScript.setName("internal");
        customScript.setLevel(-1);
        this.internalCustomScriptConfiguration = new CustomScriptConfiguration((CustomScript)customScript, (BaseExternalType)personAuthenticationType, new HashMap(0));
    }

    protected void addExternalConfigurations(List<CustomScriptConfiguration> newCustomScriptConfigurations) {
        newCustomScriptConfigurations.add(this.internalCustomScriptConfiguration);
    }

    protected void reloadExternal() {
        this.customScriptConfigurationsMapByUsageType = this.groupCustomScriptConfigurationsMapByUsageType(this.customScriptConfigurationsNameMap);
        this.defaultExternalAuthenticators = this.determineDefaultCustomScriptConfigurationsMap(this.customScriptConfigurationsNameMap);
    }

    public Map<AuthenticationScriptUsageType, List<CustomScriptConfiguration>> groupCustomScriptConfigurationsMapByUsageType(Map<String, CustomScriptConfiguration> customScriptConfigurationsMap) {
        HashMap<AuthenticationScriptUsageType, List<CustomScriptConfiguration>> newCustomScriptConfigurationsMapByUsageType = new HashMap<AuthenticationScriptUsageType, List<CustomScriptConfiguration>>();
        for (AuthenticationScriptUsageType usageType : AuthenticationScriptUsageType.values()) {
            ArrayList<CustomScriptConfiguration> currCustomScriptConfigurationsMapByUsageType = new ArrayList<CustomScriptConfiguration>();
            for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurationsMap.values()) {
                if (!this.isValidateUsageType(usageType, customScriptConfiguration)) continue;
                currCustomScriptConfigurationsMapByUsageType.add(customScriptConfiguration);
            }
            newCustomScriptConfigurationsMapByUsageType.put(usageType, currCustomScriptConfigurationsMapByUsageType);
        }
        return newCustomScriptConfigurationsMapByUsageType;
    }

    public Map<AuthenticationScriptUsageType, CustomScriptConfiguration> determineDefaultCustomScriptConfigurationsMap(Map<String, CustomScriptConfiguration> customScriptConfigurationsMap) {
        HashMap<AuthenticationScriptUsageType, CustomScriptConfiguration> newDefaultCustomScriptConfigurationsMap = new HashMap<AuthenticationScriptUsageType, CustomScriptConfiguration>();
        for (AuthenticationScriptUsageType usageType : AuthenticationScriptUsageType.values()) {
            CustomScriptConfiguration defaultExternalAuthenticator = null;
            for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
                if (defaultExternalAuthenticator != null && defaultExternalAuthenticator.getLevel() < customScriptConfiguration.getLevel()) continue;
                defaultExternalAuthenticator = customScriptConfiguration;
            }
            newDefaultCustomScriptConfigurationsMap.put(usageType, defaultExternalAuthenticator);
        }
        return newDefaultCustomScriptConfigurationsMap;
    }

    public boolean executeExternalIsValidAuthenticationMethod(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'isValidAuthenticationMethod' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.isValidAuthenticationMethod(usageType, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public String executeExternalGetAlternativeAuthenticationMethod(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'getAlternativeAuthenticationMethod' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getAlternativeAuthenticationMethod(usageType, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    public int executeExternalGetCountAuthenticationSteps(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'getCountAuthenticationSteps' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getCountAuthenticationSteps(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return -1;
        }
    }

    public boolean executeExternalAuthenticate(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug((Object)"Executing python 'authenticate' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.authenticate(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public boolean executeExternalLogout(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters) {
        try {
            this.log.debug((Object)"Executing python 'logout' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.logout(configurationAttributes, requestParameters);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public boolean executeExternalPrepareForStep(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug((Object)"Executing python 'prepareForStep' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.prepareForStep(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public List<String> executeExternalGetExtraParametersForStep(CustomScriptConfiguration customScriptConfiguration, int step) {
        try {
            this.log.debug((Object)"Executing python 'getExtraParametersForStep' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getExtraParametersForStep(configurationAttributes, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    public String executeExternalGetPageForStep(CustomScriptConfiguration customScriptConfiguration, int step) {
        try {
            this.log.debug((Object)"Executing python 'getPageForStep' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getPageForStep(configurationAttributes, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    public int executeExternalGetApiVersion(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'getApiVersion' authenticator method", new Object[0]);
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            return externalAuthenticator.getApiVersion();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return -1;
        }
    }

    public boolean isEnabled(AuthenticationScriptUsageType usageType) {
        return this.customScriptConfigurationsMapByUsageType != null && this.customScriptConfigurationsMapByUsageType.get(usageType).size() > 0;
    }

    public CustomScriptConfiguration getExternalAuthenticatorByAuthLevel(AuthenticationScriptUsageType usageType, int authLevel) {
        CustomScriptConfiguration resultDefaultExternalAuthenticator = null;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
            if (customScriptConfiguration.getLevel() != authLevel || resultDefaultExternalAuthenticator != null) continue;
            resultDefaultExternalAuthenticator = customScriptConfiguration;
        }
        return resultDefaultExternalAuthenticator;
    }

    public CustomScriptConfiguration determineCustomScriptConfiguration(AuthenticationScriptUsageType usageType, int authStep, String acr) {
        CustomScriptConfiguration customScriptConfiguration = authStep == 1 ? (StringHelper.isNotEmpty((String)acr) ? this.getCustomScriptConfiguration(usageType, acr) : this.getDefaultExternalAuthenticator(usageType)) : this.getCustomScriptConfiguration(usageType, acr);
        return customScriptConfiguration;
    }

    public CustomScriptConfiguration determineCustomScriptConfiguration(AuthenticationScriptUsageType usageType, List<String> acrValues) {
        List<String> authModes = this.getAuthModesByAcrValues(acrValues);
        if (authModes.size() > 0) {
            for (String authMode : authModes) {
                for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
                    if (!StringHelper.equalsIgnoreCase((String)authMode, (String)customScriptConfiguration.getName())) continue;
                    return customScriptConfiguration;
                }
            }
        }
        return null;
    }

    private List<String> getAuthModesByAcrValues(List<String> acrValues) {
        ArrayList<String> authModes = new ArrayList<String>();
        for (String acrValue : acrValues) {
            if (!StringHelper.isNotEmpty((String)acrValue) || !this.customScriptConfigurationsNameMap.containsKey(StringHelper.toLowerCase((String)acrValue))) continue;
            authModes.add(acrValue);
        }
        return authModes;
    }

    public CustomScriptConfiguration determineExternalAuthenticatorForWorkflow(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        String authMode = customScriptConfiguration.getName();
        this.log.debug((Object)"Validating auth_mode: '{0}'", new Object[]{authMode});
        boolean isValidAuthenticationMethod = this.executeExternalIsValidAuthenticationMethod(usageType, customScriptConfiguration);
        if (!isValidAuthenticationMethod) {
            this.log.warn((Object)"Current auth_mode: '{0}' isn't valid", new Object[]{authMode});
            String alternativeAuthenticationMethod = this.executeExternalGetAlternativeAuthenticationMethod(usageType, customScriptConfiguration);
            if (StringHelper.isEmpty((String)alternativeAuthenticationMethod)) {
                this.log.error((Object)"Failed to determine alternative authentication mode for auth_mode: '{0}'", new Object[]{authMode});
                return null;
            }
            CustomScriptConfiguration alternativeCustomScriptConfiguration = this.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, alternativeAuthenticationMethod);
            if (alternativeCustomScriptConfiguration == null) {
                this.log.error((Object)"Failed to get alternative CustomScriptConfiguration '{0}' for auth_mode: '{1}'", new Object[]{alternativeAuthenticationMethod, authMode});
                return null;
            }
            return alternativeCustomScriptConfiguration;
        }
        return customScriptConfiguration;
    }

    public CustomScriptConfiguration getDefaultExternalAuthenticator(AuthenticationScriptUsageType usageType) {
        return this.defaultExternalAuthenticators.get(usageType);
    }

    public CustomScriptConfiguration getCustomScriptConfiguration(AuthenticationScriptUsageType usageType, String name) {
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
            if (!StringHelper.equalsIgnoreCase((String)name, (String)customScriptConfiguration.getName())) continue;
            return customScriptConfiguration;
        }
        return null;
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByName(String name) {
        for (Map.Entry customScriptConfigurationEntry : this.customScriptConfigurationsNameMap.entrySet()) {
            if (!StringHelper.equalsIgnoreCase((String)name, (String)((String)customScriptConfigurationEntry.getKey()))) continue;
            return (CustomScriptConfiguration)customScriptConfigurationEntry.getValue();
        }
        return null;
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurationsMap() {
        return new ArrayList<CustomScriptConfiguration>(this.customScriptConfigurationsNameMap.values());
    }

    public List<String> getAcrValuesList() {
        ArrayList<String> acrValues = new ArrayList<String>();
        for (Map.Entry customScriptConfigurationEntry : this.customScriptConfigurationsNameMap.entrySet()) {
            String acrValue = (String)customScriptConfigurationEntry.getKey();
            acrValues.add(acrValue);
        }
        return acrValues;
    }

    private boolean isValidateUsageType(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        if (customScriptConfiguration == null) {
            return false;
        }
        AuthenticationScriptUsageType externalAuthenticatorUsageType = ((AuthenticationCustomScript)customScriptConfiguration.getCustomScript()).getUsageType();
        if (externalAuthenticatorUsageType == null) {
            externalAuthenticatorUsageType = AuthenticationScriptUsageType.INTERACTIVE;
        }
        if (AuthenticationScriptUsageType.BOTH.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        if (AuthenticationScriptUsageType.INTERACTIVE.equals((Object)usageType) && AuthenticationScriptUsageType.INTERACTIVE.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        return AuthenticationScriptUsageType.SERVICE.equals((Object)usageType) && AuthenticationScriptUsageType.SERVICE.equals((Object)externalAuthenticatorUsageType);
    }

    public static ExternalAuthenticationService instance() {
        return (ExternalAuthenticationService)((Object)Component.getInstance(ExternalAuthenticationService.class));
    }
}

