/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.custom;

import java.util.Arrays;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.model.ProgrammingLanguage;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.model.config.CustomAuthenticationConfiguration;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.model.CustomScript;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.service.LdapCustomAuthenticationConfigurationService;
import org.xdi.oxauth.service.custom.CustomScriptService;
import org.xdi.service.custom.script.CustomScriptManager;
import org.xdi.util.INumGenerator;

@Scope(value=ScopeType.APPLICATION)
@Name(value="customScriptManagerMigrator")
@AutoCreate
public class CustomScriptManagerMigrator {
    @In
    private CustomScriptManager customScriptManager;
    @In
    private CustomScriptService customScriptService;
    @Logger
    private Log log;
    private static final long serialVersionUID = -3225890597520443390L;

    public void migrateOldConfigurations() {
        List customScripts = this.customScriptService.findCustomScripts(this.customScriptManager.getSupportedCustomScriptTypes(), CustomScriptManager.CUSTOM_SCRIPT_CHECK_ATTRIBUTES);
        if (customScripts.size() > 0) {
            return;
        }
        LdapCustomAuthenticationConfigurationService ldapCustomAuthenticationConfigurationService = (LdapCustomAuthenticationConfigurationService)Component.getInstance(LdapCustomAuthenticationConfigurationService.class);
        List<CustomAuthenticationConfiguration> customAuthenticationConfigurations = ldapCustomAuthenticationConfigurationService.getCustomAuthenticationConfigurations();
        if (customAuthenticationConfigurations.size() == 0) {
            return;
        }
        String basedInum = ConfigurationFactory.instance().getConfiguration().getOrganizationInum();
        for (CustomAuthenticationConfiguration customAuthenticationConfiguration : customAuthenticationConfigurations) {
            String customScriptId = basedInum + "!" + INumGenerator.generate((int)2);
            String dn = this.customScriptService.buildDn(customScriptId);
            CustomScript customScript = new CustomScript();
            customScript.setDn(dn);
            customScript.setInum(customScriptId);
            customScript.setProgrammingLanguage(ProgrammingLanguage.PYTHON);
            customScript.setScriptType(CustomScriptType.PERSON_AUTHENTICATION);
            customScript.setName(customAuthenticationConfiguration.getName());
            customScript.setLevel(customAuthenticationConfiguration.getLevel());
            customScript.setEnabled(customAuthenticationConfiguration.isEnabled());
            customScript.setRevision((long)customAuthenticationConfiguration.getVersion());
            String script = customAuthenticationConfiguration.getCustomAuthenticationScript();
            script = script.replaceAll("from org.xdi.oxauth.service.python.interfaces import", "from org.xdi.model.custom.script.type.auth import").replaceAll("ExternalAuthenticatorType", "PersonAuthenticationType").replaceAll("ExternalAuthenticator", "PersonAuthentication");
            customScript.setScript(script);
            List<SimpleCustomProperty> moduleProperties = Arrays.asList(new SimpleCustomProperty("usage_type", customAuthenticationConfiguration.getUsageType().toString()));
            customScript.setModuleProperties(moduleProperties);
            customScript.setConfigurationProperties(customAuthenticationConfiguration.getCustomAuthenticationAttributes());
            this.customScriptService.add(customScript);
            this.log.info((Object)"Successfully imported '{0}' authentication script", new Object[]{customScript.getName()});
        }
    }

    public static CustomScriptManagerMigrator instance() {
        return (CustomScriptManagerMigrator)Component.getInstance(CustomScriptManagerMigrator.class);
    }
}

