/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.AcrChangedException;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="sessionStateService")
@AutoCreate
public class SessionStateService {
    public static final String SESSION_STATE_COOKIE_NAME = "session_state";
    public static final String SESSION_CUSTOM_STATE = "session_custom_state";
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private AuthenticationService authenticationService;

    public static SessionStateService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (SessionStateService)Component.getInstance(SessionStateService.class);
    }

    public SessionState assertAuthenticatedSessionCorrespondsToNewRequest(SessionState session, String redirectUri, String acrValuesStr) throws AcrChangedException {
        if (session != null && !session.getSessionAttributes().isEmpty() && session.getState() == SessionIdState.AUTHENTICATED) {
            boolean isAcrChanged;
            Map<String, String> sessionAttributes = session.getSessionAttributes();
            boolean bl = isAcrChanged = acrValuesStr != null && !acrValuesStr.equals(sessionAttributes.get("acr_values"));
            if (isAcrChanged) {
                throw new AcrChangedException();
            }
            Map<String, String> currentSessionAttributes = this.getCurrentSessionAttributes(sessionAttributes);
            if (!currentSessionAttributes.equals(sessionAttributes)) {
                sessionAttributes.putAll(currentSessionAttributes);
                sessionAttributes.put("auth_step", "1");
                Iterator<Map.Entry<String, String>> it = currentSessionAttributes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> currentSessionAttributesEntry = it.next();
                    String name = currentSessionAttributesEntry.getKey();
                    if (!name.startsWith("auth_step_passed_")) continue;
                    it.remove();
                }
                session.setSessionAttributes(currentSessionAttributes);
                boolean updateResult = this.updateSessionState(session, true, true);
                if (!updateResult) {
                    this.log.debug((Object)"Failed to update session entry: '{0}'", new Object[]{session.getId()});
                }
            }
        }
        return session;
    }

    private Map<String, String> getCurrentSessionAttributes(Map<String, String> sessionAttributes) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            HashMap<String, String> currentSessionAttributes = new HashMap<String, String>(sessionAttributes);
            ExternalContext externalContext = facesContext.getExternalContext();
            Map parameterMap = externalContext.getRequestParameterMap();
            Map<String, String> newRequestParameterMap = this.authenticationService.getAllowedParameters(parameterMap);
            for (Map.Entry<String, String> newRequestParameterMapEntry : newRequestParameterMap.entrySet()) {
                String name = newRequestParameterMapEntry.getKey();
                if (StringHelper.equalsIgnoreCase((String)name, (String)"auth_step")) continue;
                currentSessionAttributes.put(name, newRequestParameterMapEntry.getValue());
            }
            return currentSessionAttributes;
        }
        return sessionAttributes;
    }

    public String getSessionStateFromCookie(HttpServletRequest request) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(SESSION_STATE_COOKIE_NAME)) continue;
                    this.log.trace((Object)"Found session_state cookie: '{0}'", new Object[]{cookie.getValue()});
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return "";
    }

    public String getSessionStateFromCookie() {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            return this.getSessionStateFromCookie(request);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void createSessionStateCookie(String sessionState) {
        try {
            Object response = FacesContext.getCurrentInstance().getExternalContext().getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String header = "session_state=" + sessionState;
                header = header + "; Path=/";
                header = header + "; Secure";
                httpResponse.addHeader("Set-Cookie", header);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void removeSessionStateCookie() {
        try {
            Object response;
            FacesContext currentInstance = FacesContext.getCurrentInstance();
            if (currentInstance != null && currentInstance.getExternalContext() != null && (response = currentInstance.getExternalContext().getResponse()) instanceof HttpServletResponse) {
                this.removeSessionStateCookie((HttpServletResponse)response);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void removeSessionStateCookie(HttpServletResponse httpResponse) {
        Cookie cookie = new Cookie(SESSION_STATE_COOKIE_NAME, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        httpResponse.addCookie(cookie);
    }

    public SessionState getSessionState() {
        String sessionState = this.getSessionStateFromCookie();
        if (StringHelper.isNotEmpty((String)sessionState)) {
            return this.getSessionState(sessionState);
        }
        return null;
    }

    public Map<String, String> getSessionAttributes(SessionState sessionState) {
        if (sessionState != null) {
            return sessionState.getSessionAttributes();
        }
        return null;
    }

    public SessionState generateAuthenticatedSessionState(String userDn) {
        return this.generateAuthenticatedSessionState(userDn, "");
    }

    public SessionState generateAuthenticatedSessionState(String userDn, String prompt) {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", prompt);
        return this.generateSessionState(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionState generateAuthenticatedSessionState(String userDn, Map<String, String> sessionIdAttributes) {
        return this.generateSessionState(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionState generateSessionState(String p_userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        String uuid = UUID.randomUUID().toString();
        String dn = SessionStateService.dn(uuid);
        if (StringUtils.isBlank((String)dn)) {
            return null;
        }
        if (SessionIdState.AUTHENTICATED == state && StringUtils.isBlank((String)p_userDn)) {
            return null;
        }
        SessionState sessionState = new SessionState();
        sessionState.setId(uuid);
        sessionState.setDn(dn);
        if (StringUtils.isNotBlank((String)p_userDn)) {
            sessionState.setUserDn(p_userDn);
        }
        if (authenticationDate != null) {
            sessionState.setAuthenticationTime(authenticationDate);
        }
        if (state != null) {
            sessionState.setState(state);
        }
        sessionState.setSessionAttributes(sessionIdAttributes);
        boolean persisted = false;
        if (persist) {
            persisted = this.persistSessionState(sessionState);
        }
        this.log.trace((Object)"Generated new session, id = '{0}', state = '{1}', persisted = '{2}'", new Object[]{sessionState.getId(), sessionState.getState(), persisted});
        return sessionState;
    }

    public SessionState setSessionStateAuthenticated(SessionState sessionState, String p_userDn) {
        sessionState.setUserDn(p_userDn);
        sessionState.setAuthenticationTime(new Date());
        sessionState.setState(SessionIdState.AUTHENTICATED);
        boolean persisted = this.updateSessionState(sessionState, true, true);
        this.log.trace((Object)"Authenticated session, id = '{0}', state = '{1}', persisted = '{2}'", new Object[]{sessionState.getId(), sessionState.getState(), persisted});
        return sessionState;
    }

    public boolean persistSessionState(SessionState sessionState) {
        return this.persistSessionState(sessionState, false);
    }

    public boolean persistSessionState(SessionState sessionState, boolean forcePersistence) {
        List<Prompt> prompts = this.getPromptsFromSessionState(sessionState);
        try {
            int unusedLifetime = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && SessionStateService.isPersisted(prompts) || forcePersistence) {
                sessionState.setLastUsedAt(new Date());
                sessionState.setPersisted(true);
                this.ldapEntryManager.persist((Object)sessionState);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return false;
    }

    public boolean updateSessionState(SessionState sessionState) {
        return this.updateSessionState(sessionState, true);
    }

    public boolean updateSessionState(SessionState sessionState, boolean updateLastUsedAt) {
        return this.updateSessionState(sessionState, updateLastUsedAt, false);
    }

    public boolean updateSessionState(SessionState sessionState, boolean updateLastUsedAt, boolean forceUpdate) {
        List<Prompt> prompts = this.getPromptsFromSessionState(sessionState);
        try {
            int unusedLifetime = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && SessionStateService.isPersisted(prompts) || forceUpdate) {
                if (updateLastUsedAt) {
                    sessionState.setLastUsedAt(new Date());
                }
                sessionState.setPersisted(true);
                this.ldapEntryManager.merge((Object)sessionState);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean isPersisted(List<Prompt> prompts) {
        if (prompts != null && prompts.contains(Prompt.NONE)) {
            Boolean persistOnPromptNone = ConfigurationFactory.instance().getConfiguration().getSessionIdPersistOnPromptNone();
            return persistOnPromptNone != null && persistOnPromptNone != false;
        }
        return true;
    }

    private static String dn(String p_id) {
        String baseDn = SessionStateService.getBaseDn();
        StringBuilder sb = new StringBuilder();
        if (Util.allNotBlank((String[])new String[]{p_id, SessionStateService.getBaseDn()})) {
            sb.append("uniqueIdentifier=").append(p_id).append(",").append(baseDn);
        }
        return sb.toString();
    }

    public SessionState getSessionByDN(String p_dn) {
        try {
            return (SessionState)this.ldapEntryManager.find(SessionState.class, (Object)p_dn);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public SessionState getSessionState(String sessionState) {
        if (StringHelper.isEmpty((String)sessionState)) {
            return null;
        }
        String dn = SessionStateService.dn(sessionState);
        boolean contains = this.containsSessionState(dn);
        if (!contains) {
            return null;
        }
        try {
            SessionState entity = this.getSessionByDN(dn);
            this.log.trace((Object)"Try to get session by id: {0} ...", new Object[]{sessionState});
            if (entity != null) {
                this.log.trace((Object)"Session dn: {0}", new Object[]{entity.getDn()});
                if (this.isSessionValid(entity)) {
                    return entity;
                }
            }
        }
        catch (Exception ex) {
            this.log.trace((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        this.log.trace((Object)"Failed to get session by id: {0}", new Object[]{sessionState});
        return null;
    }

    public boolean containsSessionState(String dn) {
        try {
            return this.ldapEntryManager.contains(SessionState.class, dn);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
    }

    private static String getBaseDn() {
        return ConfigurationFactory.instance().getBaseDn().getSessionId();
    }

    public boolean remove(SessionState p_sessionState) {
        try {
            this.ldapEntryManager.remove((Object)p_sessionState);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
        return true;
    }

    public void remove(List<SessionState> list) {
        for (SessionState id : list) {
            this.remove(id);
        }
    }

    public void cleanUpSessions() {
        int interval = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
        int unauthenticatedInterval = ConfigurationFactory.instance().getConfiguration().getSessionIdUnauthenticatedUnusedLifetime();
        this.remove(this.getUnauthenticatedIdsOlderThan(unauthenticatedInterval));
        this.remove(this.getIdsOlderThan(interval));
    }

    public List<SessionState> getUnauthenticatedIdsOlderThan(int p_intervalInSeconds) {
        try {
            long dateInPast = new Date().getTime() - TimeUnit.SECONDS.toMillis(p_intervalInSeconds);
            Filter filter = Filter.create((String)String.format("&(lastModifiedTime<=%s)(oxState=unauthenticated)", StaticUtils.encodeGeneralizedTime((Date)new Date(dateInPast))));
            return this.ldapEntryManager.findEntries(SessionStateService.getBaseDn(), SessionState.class, filter);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<SessionState> getIdsOlderThan(int p_intervalInSeconds) {
        try {
            long dateInPast = new Date().getTime() - TimeUnit.SECONDS.toMillis(p_intervalInSeconds);
            Filter filter = Filter.create((String)String.format("(lastModifiedTime<=%s)", StaticUtils.encodeGeneralizedTime((Date)new Date(dateInPast))));
            return this.ldapEntryManager.findEntries(SessionStateService.getBaseDn(), SessionState.class, filter);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public boolean isSessionValid(SessionState sessionState) {
        if (sessionState == null) {
            return false;
        }
        long sessionInterval = TimeUnit.SECONDS.toMillis(ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime());
        long sessionUnauthenticatedInterval = TimeUnit.SECONDS.toMillis(ConfigurationFactory.instance().getConfiguration().getSessionIdUnauthenticatedUnusedLifetime());
        long timeSinceLastAccess = System.currentTimeMillis() - sessionState.getLastUsedAt().getTime();
        if (timeSinceLastAccess > sessionInterval && ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime() != -1) {
            return false;
        }
        return sessionState.getState() != SessionIdState.UNAUTHENTICATED || timeSinceLastAccess <= sessionUnauthenticatedInterval || ConfigurationFactory.instance().getConfiguration().getSessionIdUnauthenticatedUnusedLifetime() == -1;
    }

    private List<Prompt> getPromptsFromSessionState(SessionState sessionState) {
        String promptParam = sessionState.getSessionAttributes().get("prompt");
        return Prompt.fromString((String)promptParam, (String)" ");
    }
}

