/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.ldap.SectorIdentifier;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="sectorIdentifierService")
@AutoCreate
public class SectorIdentifierService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public static SectorIdentifierService instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (SectorIdentifierService)Component.getInstance(SectorIdentifierService.class);
    }

    public SectorIdentifier getSectorIdentifierByInum(String inum) {
        SectorIdentifier result = null;
        try {
            result = (SectorIdentifier)this.ldapEntryManager.find(SectorIdentifier.class, (Object)this.getDnForSectorIdentifier(inum));
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to find sector identifier by Inum " + inum), (Throwable)e, new Object[0]);
        }
        return result;
    }

    public String getDnForSectorIdentifier(String inum) {
        String sectorIdentifierDn = ConfigurationFactory.instance().getBaseDn().getSectorIdentifiers();
        if (StringHelper.isEmpty((String)inum)) {
            return sectorIdentifierDn;
        }
        return String.format("inum=%s,%s", inum, sectorIdentifierDn);
    }
}

