/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.common.PairwiseIdType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.ldap.PairwiseIdentifier;
import org.xdi.oxauth.model.util.SubjectIdentifierGenerator;
import org.xdi.oxauth.service.UserService;

@Scope(value=ScopeType.STATELESS)
@Name(value="pairwiseIdentifierService")
@AutoCreate
public class PairwiseIdentifierService {
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private UserService userService;
    @Logger
    private Log log;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("pairwiseIdentifiers");
        branch.setDn(this.getBaseDnForPairwiseIdentifiers(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getBaseDnForPairwiseIdentifiers(userInum));
    }

    public void prepareBranch(String userInum) {
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public PairwiseIdentifier findPairWiseIdentifier(String userInum, String sectorIdentifierUri) throws InvalidKeyException, NoSuchAlgorithmException {
        PairwiseIdType pairwiseIdType = PairwiseIdType.fromString((String)ConfigurationFactory.instance().getConfiguration().getPairwiseIdType());
        if (PairwiseIdType.PERSISTENT == pairwiseIdType) {
            this.prepareBranch(userInum);
            String baseDnForPairwiseIdentifiers = this.getBaseDnForPairwiseIdentifiers(userInum);
            Filter filter = Filter.createEqualityFilter((String)"oxSectorIdentifierURI", (String)sectorIdentifierUri);
            List entries = this.ldapEntryManager.findEntries(baseDnForPairwiseIdentifiers, PairwiseIdentifier.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error((Object)("Found more then one pairwise identifier by sector identifier: {0}" + sectorIdentifierUri), new Object[0]);
                    for (PairwiseIdentifier pairwiseIdentifier : entries) {
                        this.log.error((Object)pairwiseIdentifier, new Object[0]);
                    }
                }
                return (PairwiseIdentifier)((Object)entries.get(0));
            }
        } else {
            String key = ConfigurationFactory.instance().getConfiguration().getPairwiseCalculationKey();
            String salt = ConfigurationFactory.instance().getConfiguration().getPairwiseCalculationSalt();
            String calculatedSub = SubjectIdentifierGenerator.generatePairwiseSubjectIdentifier((String)sectorIdentifierUri, (String)userInum, (String)key, (String)salt);
            PairwiseIdentifier pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri);
            pairwiseIdentifier.setId(calculatedSub);
            return pairwiseIdentifier;
        }
        return null;
    }

    public void addPairwiseIdentifier(String userInum, PairwiseIdentifier pairwiseIdentifier) {
        this.prepareBranch(userInum);
        this.ldapEntryManager.persist((Object)pairwiseIdentifier);
    }

    public String getDnForPairwiseIdentifier(String oxId, String userInum) {
        String baseDn = this.getBaseDnForPairwiseIdentifiers(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForPairwiseIdentifiers(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=pairwiseIdentifiers,%s", userBaseDn);
    }

    public static PairwiseIdentifierService instance() {
        return (PairwiseIdentifierService)Component.getInstance(PairwiseIdentifierService.class);
    }
}

