/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.model.config.CustomAuthenticationConfiguration;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.config.CustomProperty;
import org.xdi.oxauth.model.config.oxIDPAuthConf;
import org.xdi.oxauth.service.ApplianceService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="ldapCustomAuthenticationConfigurationService")
@AutoCreate
public class LdapCustomAuthenticationConfigurationService
implements Serializable {
    private static final long serialVersionUID = -2225890597520443390L;
    private static final String CUSTOM_AUTHENTICATION_SCRIPT_PROPERTY_NAME = "script.__$__customAuthenticationScript__$__";
    private static final String CUSTOM_AUTHENTICATION_PROPERTY_PREFIX = "property.";
    private static final String CUSTOM_AUTHENTICATION_SCRIPT_USAGE_TYPE = "usage.";
    @Logger
    private Log log;
    @In
    private ApplianceService applianceService;

    public List<CustomAuthenticationConfiguration> getCustomAuthenticationConfigurations() {
        GluuAppliance gluuAppliance = this.applianceService.getAppliance();
        List<String> configurationJsons = gluuAppliance.getOxIDPAuthentication();
        ArrayList<CustomAuthenticationConfiguration> customAuthenticationConfigurations = new ArrayList<CustomAuthenticationConfiguration>();
        if (configurationJsons == null) {
            return customAuthenticationConfigurations;
        }
        for (String configurationJson : configurationJsons) {
            try {
                oxIDPAuthConf configuration = (oxIDPAuthConf)this.jsonToObject(configurationJson, oxIDPAuthConf.class);
                if (!configuration.getEnabled() || !configuration.getType().equalsIgnoreCase("customAuthentication")) continue;
                CustomAuthenticationConfiguration customAuthenticationConfiguration = this.mapCustomAuthentication(configuration);
                customAuthenticationConfigurations.add(customAuthenticationConfiguration);
            }
            catch (Exception ex) {
                this.log.error((Object)"Failed to create object by json: '{0}'", (Throwable)ex, new Object[]{configurationJson});
            }
        }
        return customAuthenticationConfigurations;
    }

    private CustomAuthenticationConfiguration mapCustomAuthentication(oxIDPAuthConf oneConf) {
        CustomAuthenticationConfiguration customAuthenticationConfig = new CustomAuthenticationConfiguration();
        customAuthenticationConfig.setName(oneConf.getName());
        customAuthenticationConfig.setLevel(oneConf.getLevel());
        customAuthenticationConfig.setPriority(oneConf.getPriority());
        customAuthenticationConfig.setEnabled(oneConf.getEnabled());
        customAuthenticationConfig.setVersion(oneConf.getVersion());
        for (CustomProperty customProperty : oneConf.getFields()) {
            String attrName;
            if (customProperty.getValues() == null || customProperty.getValues().size() == 0 || StringHelper.isEmpty((String)(attrName = StringHelper.toLowerCase((String)customProperty.getName())))) continue;
            String value = customProperty.getValues().get(0);
            if (attrName.startsWith(CUSTOM_AUTHENTICATION_PROPERTY_PREFIX)) {
                String key = customProperty.getName().substring(CUSTOM_AUTHENTICATION_PROPERTY_PREFIX.length());
                SimpleCustomProperty property = new SimpleCustomProperty(key, value);
                customAuthenticationConfig.getCustomAuthenticationAttributes().add(property);
                continue;
            }
            if (StringHelper.equalsIgnoreCase((String)attrName, (String)CUSTOM_AUTHENTICATION_SCRIPT_PROPERTY_NAME)) {
                customAuthenticationConfig.setCustomAuthenticationScript(value);
                continue;
            }
            if (!StringHelper.equalsIgnoreCase((String)attrName, (String)CUSTOM_AUTHENTICATION_SCRIPT_USAGE_TYPE) || !StringHelper.isNotEmpty((String)value)) continue;
            AuthenticationScriptUsageType authenticationScriptUsageType = AuthenticationScriptUsageType.getByValue((String)value);
            customAuthenticationConfig.setUsageType(authenticationScriptUsageType);
        }
        return customAuthenticationConfig;
    }

    private Object jsonToObject(String json, Class<?> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Object clazzObject = mapper.readValue(json, clazz);
        return clazzObject;
    }
}

