/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.idgen.ws.rs.IdGenService;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.util.Pair;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="inumService")
@AutoCreate
public class InumService {
    @Logger
    private Log log;
    @In
    private IdGenService idGenService;

    public String generateClientInum() {
        return this.generateClientInum(ConfigurationFactory.instance().getConfiguration().getOrganizationInum());
    }

    public String generateClientInum(String p_organizationInum) {
        return this.idGenService.generateId(IdType.CLIENTS, p_organizationInum);
    }

    public String generatePeopleInum() {
        return this.idGenService.generateId(IdType.PEOPLE, ConfigurationFactory.instance().getConfiguration().getOrganizationInum());
    }

    public String generateInum() {
        return this.generateClientInum();
    }

    public Pair<String, String> generateNewDN(String baseDn) {
        String inum = this.generateInum();
        StringBuilder dnSb = new StringBuilder("inum=");
        dnSb.append(inum).append(",").append(baseDn);
        String dn = dnSb.toString();
        this.log.trace((Object)"Generated dn: {0}", new Object[]{dn});
        return new Pair((Object)inum, (Object)dn);
    }

    public static InumService instance() {
        return (InumService)ServerUtil.instance(InumService.class);
    }
}

