/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.StaticUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.ldap.Grant;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="grantService")
@AutoCreate
public class GrantService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public static String generateGrantId() {
        return UUID.randomUUID().toString();
    }

    public static String buildDn(String p_uniqueIdentifier, String p_grantId, String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("uniqueIdentifier=%s,oxAuthGrantId=%s,", p_uniqueIdentifier, p_grantId));
        dn.append(Client.buildClientDn(p_clientId));
        return dn.toString();
    }

    public static String baseDn() {
        return ConfigurationFactory.instance().getBaseDn().getClients();
    }

    public static GrantService instance() {
        return (GrantService)ServerUtil.instance(GrantService.class);
    }

    public void merge(TokenLdap p_token) {
        this.ldapEntryManager.merge((Object)p_token);
    }

    public void mergeSilently(TokenLdap p_token) {
        try {
            this.ldapEntryManager.merge((Object)p_token);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void persist(TokenLdap p_token) {
        this.prepareGrantBranch(p_token.getGrantId(), p_token.getClientId());
        this.ldapEntryManager.persist((Object)p_token);
    }

    public void remove(TokenLdap p_token) {
        this.ldapEntryManager.remove((Object)p_token);
        this.log.trace((Object)("Removed token, code: " + p_token.getTokenCode()), new Object[0]);
    }

    public void removeSilently(TokenLdap p_token) {
        try {
            this.remove(p_token);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void remove(List<TokenLdap> p_entries) {
        if (p_entries != null && !p_entries.isEmpty()) {
            for (TokenLdap t : p_entries) {
                this.remove(t);
            }
        }
    }

    public void removeSilently(List<TokenLdap> p_entries) {
        if (p_entries != null && !p_entries.isEmpty()) {
            for (TokenLdap t : p_entries) {
                this.removeSilently(t);
            }
        }
    }

    public void remove(AuthorizationGrant p_grant) {
        if (p_grant != null && p_grant.getTokenLdap() != null) {
            try {
                this.remove(p_grant.getTokenLdap());
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }

    public List<TokenLdap> getGrantsOfClient(String p_clientId) {
        try {
            String baseDn = Client.buildClientDn(p_clientId);
            return this.ldapEntryManager.findEntries(baseDn, TokenLdap.class, Filter.create((String)"oxAuthTokenCode=*"));
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public TokenLdap getGrantsByCodeAndClient(String p_code, String p_clientId) {
        return this.load(Client.buildClientDn(p_clientId), p_code);
    }

    public TokenLdap getGrantsByCode(String p_code) {
        return this.load(GrantService.baseDn(), p_code);
    }

    private TokenLdap load(String p_baseDn, String p_code) {
        try {
            List entries = this.ldapEntryManager.findEntries(p_baseDn, TokenLdap.class, Filter.create((String)String.format("oxAuthTokenCode=%s", p_code)));
            if (entries != null && !entries.isEmpty()) {
                return (TokenLdap)entries.get(0);
            }
        }
        catch (LDAPException e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public List<TokenLdap> getGrantsByGrantId(String p_grantId) {
        try {
            return this.ldapEntryManager.findEntries(GrantService.baseDn(), TokenLdap.class, Filter.create((String)String.format("oxAuthGrantId=%s", p_grantId)));
        }
        catch (LDAPException e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return Collections.emptyList();
    }

    public List<TokenLdap> getGrantsByAuthorizationCode(String p_authorizationCode) {
        try {
            return this.ldapEntryManager.findEntries(GrantService.baseDn(), TokenLdap.class, Filter.create((String)String.format("oxAuthAuthorizationCode=%s", p_authorizationCode)));
        }
        catch (LDAPException e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return Collections.emptyList();
    }

    public void removeByCode(String p_code, String p_clientId) {
        TokenLdap t = this.getGrantsByCodeAndClient(p_code, p_clientId);
        if (t != null) {
            this.removeSilently(t);
        }
    }

    public void removeAllByAuthorizationCode(String p_authorizationCode) {
        this.removeSilently(this.getGrantsByAuthorizationCode(p_authorizationCode));
    }

    public void removeAllByGrantId(String p_grantId) {
        this.removeSilently(this.getGrantsByGrantId(p_grantId));
    }

    public void cleanUp() {
        try {
            Filter filter = Filter.create((String)String.format("(oxAuthExpiration<=%s)", StaticUtils.encodeGeneralizedTime((Date)new Date())));
            List entries = this.ldapEntryManager.findEntries(GrantService.baseDn(), TokenLdap.class, filter);
            this.remove(entries);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void addGrantBranch(String p_grantId, String p_clientId) {
        Grant grant = new Grant();
        grant.setDn(this.getBaseDnForGrant(p_grantId, p_clientId));
        grant.setId(p_grantId);
        this.ldapEntryManager.persist((Object)grant);
    }

    private void prepareGrantBranch(String p_grantId, String p_clientId) {
        if (!this.containsGrantBranch(p_grantId, p_clientId)) {
            this.addGrantBranch(p_grantId, p_clientId);
        }
    }

    private boolean containsGrantBranch(String p_grantId, String p_clientId) {
        return this.ldapEntryManager.contains(Grant.class, this.getBaseDnForGrant(p_grantId, p_clientId));
    }

    private String getBaseDnForGrant(String p_grantId, String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("oxAuthGrantId=%s,", p_grantId));
        dn.append(Client.buildClientDn(p_clientId));
        return dn.toString();
    }
}

