/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.Properties;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;
import org.xdi.util.security.PropertiesDecrypter;
import org.xdi.util.security.StringEncrypter;

@Scope(value=ScopeType.STATELESS)
@Name(value="encryptionService")
@AutoCreate
public class EncryptionService {
    @Logger
    private Log log;
    @In
    private StringEncrypter stringEncrypter;

    public String decrypt(String encryptedString) throws StringEncrypter.EncryptionException {
        if (StringHelper.isEmpty((String)encryptedString)) {
            return null;
        }
        return this.stringEncrypter.decrypt(encryptedString);
    }

    public String encrypt(String unencryptedString) throws StringEncrypter.EncryptionException {
        if (StringHelper.isEmpty((String)unencryptedString)) {
            return null;
        }
        return this.stringEncrypter.encrypt(unencryptedString);
    }

    public Properties decryptProperties(Properties connectionProperties) {
        return PropertiesDecrypter.decryptProperties((StringEncrypter)this.stringEncrypter, (Properties)connectionProperties);
    }

    public static EncryptionService instance() {
        return (EncryptionService)ServerUtil.instance(EncryptionService.class);
    }
}

