/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.google.common.collect.Sets;
import com.unboundid.ldap.sdk.Filter;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.python.jline.internal.Preconditions;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.CustomEntry;
import org.xdi.model.SimpleProperty;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientFilterService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.service.CacheService;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Scope(value=ScopeType.STATELESS)
@Name(value="clientService")
@AutoCreate
public class ClientService {
    public static final String EVENT_CLEAR_CLIENT_CACHE = "eventClearClient";
    private static final String CACHE_CLIENT_NAME = "ClientCache";
    private static final String CACHE_CLIENT_FILTER_NAME = "ClientFilterCache";
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private CacheService cacheService;
    @In
    private ClientFilterService clientFilterService;

    public static ClientService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (ClientService)ServerUtil.instance(ClientService.class);
    }

    public void persist(Client client) {
        this.ldapEntryManager.persist((Object)client);
    }

    public void merge(Client client) {
        this.ldapEntryManager.merge((Object)client);
        this.removeFromCache(client);
    }

    public boolean authenticate(String clientId, String password) {
        this.log.debug((Object)"Authenticating Client with LDAP: clientId = {0}", new Object[]{clientId});
        boolean authenticated = false;
        try {
            Client client = this.getClient(clientId);
            authenticated = client != null && client.getClientSecret() != null && client.getClientSecret().equals(password);
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return authenticated;
    }

    public Set<Client> getClient(Collection<String> clientIds, boolean silent) {
        HashSet set = Sets.newHashSet();
        if (clientIds == null) {
            return set;
        }
        for (String clientId : clientIds) {
            try {
                set.add(this.getClient(clientId));
            }
            catch (RuntimeException e) {
                if (silent) continue;
                throw e;
            }
        }
        return set;
    }

    public Client getClient(String clientId) {
        if (clientId != null && !clientId.isEmpty()) {
            String dn;
            if (Boolean.TRUE.equals(ConfigurationFactory.instance().getConfiguration().getClientAuthenticationFiltersEnabled()) && StringUtils.isNotBlank((String)(dn = this.getClientDnByFilters(clientId)))) {
                return this.getClientByDn(dn);
            }
            Client result = this.getClientByDn(Client.buildClientDn(clientId));
            this.log.debug((Object)"Found {0} entries for client id = {1}", new Object[]{result != null ? 1 : 0, clientId});
            return result;
        }
        return null;
    }

    private String getClientDnByFilters(String clientId) {
        String key = this.getClientIdCacheKey(clientId);
        SimpleProperty simpleProperty = (SimpleProperty)this.cacheService.get(CACHE_CLIENT_FILTER_NAME, key);
        if (simpleProperty == null) {
            simpleProperty = new SimpleProperty(this.clientFilterService.processFilters(clientId));
            this.cacheService.put(CACHE_CLIENT_FILTER_NAME, key, (Object)simpleProperty);
        } else {
            this.log.trace((Object)"Get client Dn '{0}' from cache by Id '{1}'", new Object[]{simpleProperty.getValue(), clientId});
        }
        return simpleProperty.getValue();
    }

    public Client getClient(String clientId, String registrationAccessToken) {
        String baseDN = ConfigurationFactory.instance().getBaseDn().getClients();
        Client client = new Client();
        client.setDn(baseDN);
        client.setClientId(clientId);
        client.setRegistrationAccessToken(registrationAccessToken);
        List clients = this.ldapEntryManager.findEntries((Object)client);
        if (clients != null && clients.size() > 0) {
            return (Client)clients.get(0);
        }
        return null;
    }

    public Set<Client> getClientsByDns(Collection<String> dnList) {
        return this.getClientsByDns(dnList, true);
    }

    public Set<Client> getClientsByDns(Collection<String> dnList, boolean silently) {
        Preconditions.checkNotNull(dnList);
        HashSet result = Sets.newHashSet();
        for (String clientDn : dnList) {
            try {
                result.add(this.getClientByDn(clientDn));
            }
            catch (RuntimeException e) {
                if (silently) continue;
                throw e;
            }
        }
        return result;
    }

    public Client getClientByDn(String dn) {
        String key = this.getClientDnCacheKey(dn);
        Client client = (Client)this.cacheService.get(CACHE_CLIENT_NAME, key);
        if (client == null) {
            client = (Client)this.ldapEntryManager.find(Client.class, (Object)dn);
            this.cacheService.put(CACHE_CLIENT_NAME, key, (Object)client);
        } else {
            this.log.trace((Object)"Get client from cache by Dn '{0}'", new Object[]{dn});
        }
        return client;
    }

    public CustomAttribute getCustomAttribute(Client client, String attributeName) {
        for (CustomAttribute customAttribute : client.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)customAttribute.getName())) continue;
            return customAttribute;
        }
        return null;
    }

    public void setCustomAttribute(Client client, String attributeName, String attributeValue) {
        CustomAttribute customAttribute = this.getCustomAttribute(client, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomAttribute(attributeName);
            client.getCustomAttributes().add(customAttribute);
        }
        customAttribute.setValue(attributeValue);
    }

    public List<Client> getAllClients(String[] returnAttributes) {
        String baseDn = ConfigurationFactory.instance().getBaseDn().getClients();
        List result = this.ldapEntryManager.findEntries(baseDn, Client.class, returnAttributes, null);
        return result;
    }

    public List<Client> getClientsWithExpirationDate(String[] returnAttributes) {
        String baseDN = ConfigurationFactory.instance().getBaseDn().getClients();
        Filter filter = Filter.createPresenceFilter((String)"oxAuthClientSecretExpiresAt");
        return this.ldapEntryManager.findEntries(baseDN, Client.class, filter);
    }

    public void remove(Client client) {
        if (client != null) {
            this.removeFromCache(client);
            String clientDn = client.getDn();
            this.ldapEntryManager.removeWithSubtree(clientDn);
        }
    }

    private void removeFromCache(Client client) {
        String clientId = client.getClientId();
        String clientDn = client.getDn();
        this.cacheService.remove(CACHE_CLIENT_FILTER_NAME, this.getClientIdCacheKey(clientId));
        this.cacheService.remove(CACHE_CLIENT_NAME, this.getClientDnCacheKey(clientDn));
    }

    @Observer(value={"eventClearClient"})
    public void clearClientCache() {
        this.log.debug((Object)"Clearing up clients cache", new Object[0]);
        this.cacheService.removeAll(CACHE_CLIENT_NAME);
        this.cacheService.removeAll(CACHE_CLIENT_FILTER_NAME);
    }

    public void updatAccessTime(Client client, boolean isUpdateLogonTime) {
        String clientDn = client.getDn();
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(clientDn);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        CustomAttribute customAttributeLastAccessTime = new CustomAttribute("oxLastAccessTime", now);
        customEntry.getCustomAttributes().add(customAttributeLastAccessTime);
        if (isUpdateLogonTime) {
            CustomAttribute customAttributeLastLogonTime = new CustomAttribute("oxLastLogonTime", now);
            customEntry.getCustomAttributes().add(customAttributeLastLogonTime);
        }
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error((Object)"Failed to update oxLastAccessTime and oxLastLoginTime of client '{0}'", new Object[]{clientDn});
        }
        this.removeFromCache(client);
    }

    private String getClientIdCacheKey(String clientId) {
        return "client_id_" + StringHelper.toLowerCase((String)clientId);
    }

    private String getClientDnCacheKey(String dn) {
        return "client_dn_" + StringHelper.toLowerCase((String)dn);
    }
}

