/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.ldap.ClientAuthorizations;
import org.xdi.oxauth.service.UserService;

@Scope(value=ScopeType.STATELESS)
@Name(value="clientAuthorizationsService")
@AutoCreate
public class ClientAuthorizationsService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private UserService userService;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("clientAuthorizations");
        branch.setDn(this.getBaseDnForClientAuthorizations(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getBaseDnForClientAuthorizations(userInum));
    }

    public void prepareBranch(String userInum) {
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public ClientAuthorizations findClientAuthorizations(String userInum, String clientId) {
        this.prepareBranch(userInum);
        String baseDn = this.getBaseDnForClientAuthorizations(userInum);
        Filter filter = Filter.createEqualityFilter((String)"oxAuthClientId", (String)clientId);
        List entries = this.ldapEntryManager.findEntries(baseDn, ClientAuthorizations.class, filter);
        if (entries != null && !entries.isEmpty()) {
            if (entries.size() > 1) {
                this.log.error((Object)("Found more then one client authorization entry by client Id: {0}" + clientId), new Object[0]);
                for (ClientAuthorizations entry : entries) {
                    this.log.error((Object)entry, new Object[0]);
                }
            }
            return (ClientAuthorizations)entries.get(0);
        }
        return null;
    }

    public void add(String userInum, String clientId, List<String> scopes) {
        this.prepareBranch(userInum);
        ClientAuthorizations clientAuthorizations = this.findClientAuthorizations(userInum, clientId);
        if (clientAuthorizations == null) {
            clientAuthorizations = new ClientAuthorizations();
            clientAuthorizations.setId(UUID.randomUUID().toString());
            clientAuthorizations.setClientId(clientId);
            clientAuthorizations.setScopes(scopes.toArray(new String[scopes.size()]));
            clientAuthorizations.setDn(this.getBaseDnForClientAuthorizations(clientAuthorizations.getId(), userInum));
            this.ldapEntryManager.persist((Object)clientAuthorizations);
        } else {
            HashSet<String> set = new HashSet<String>(scopes);
            set.addAll(Arrays.asList(clientAuthorizations.getScopes()));
            clientAuthorizations.setScopes(set.toArray(new String[set.size()]));
            this.ldapEntryManager.merge((Object)clientAuthorizations);
        }
    }

    public String getBaseDnForClientAuthorizations(String oxId, String userInum) {
        String baseDn = this.getBaseDnForClientAuthorizations(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForClientAuthorizations(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=clientAuthorizations,%s", userBaseDn);
    }

    public static ClientAuthorizationsService instance() {
        return (ClientAuthorizationsService)Component.getInstance(ClientAuthorizationsService.class);
    }
}

