/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.model.ApplicationType;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.RequestMessageLdap;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RequestService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;

@Name(value="cleanerTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class CleanerTimer {
    private static final String EVENT_TYPE = "CleanerTimerEvent";
    private static final int DEFAULT_INTERVAL = 600;
    @Logger
    private Log log;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ClientService clientService;
    @In
    private GrantService grantService;
    @In
    private RPTManager rptManager;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;
    @In
    private SessionStateService sessionStateService;
    @In
    private RequestService u2fRequestService;
    @In
    private MetricService metricService;
    @In
    private DeviceRegistrationService deviceRegistrationService;
    private AtomicBoolean isActive;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.log.debug((Object)"Initializing CleanerTimer", new Object[0]);
        this.isActive = new AtomicBoolean(false);
        long interval = ConfigurationFactory.instance().getConfiguration().getCleanServiceInterval();
        if (interval <= 0L) {
            interval = 600L;
        }
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(interval *= 1000L), Long.valueOf(interval)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"CleanerTimerEvent"})
    @Asynchronous
    public void process() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processAuthorizationGrantList();
            this.processRegisteredClients();
            this.sessionStateService.cleanUpSessions();
            Date now = new Date();
            this.rptManager.cleanupRPTs(now);
            this.resourceSetPermissionManager.cleanupResourceSetPermissions(now);
            this.processU2fRequests();
            this.processU2fDeviceRegistrations();
            this.processMetricEntries();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processAuthorizationGrantList() {
        this.log.debug((Object)"Start AuthorizationGrant clean up", new Object[0]);
        switch (ConfigurationFactory.instance().getConfiguration().getModeEnum()) {
            case IN_MEMORY: {
                List<AuthorizationGrant> grantList = this.authorizationGrantList.getAuthorizationGrants();
                if (grantList == null || grantList.isEmpty()) break;
                ArrayList<AuthorizationGrant> toRemove = new ArrayList<AuthorizationGrant>();
                for (AuthorizationGrant grant : grantList) {
                    if (grant.isValid()) continue;
                    toRemove.add(grant);
                    this.log.debug((Object)"Removing AuthorizationGrant, Client {0}", new Object[]{grant.getClient().getClientId()});
                }
                this.authorizationGrantList.removeAuthorizationGrants(toRemove);
                break;
            }
            case LDAP: {
                this.grantService.cleanUp();
            }
        }
        this.log.debug((Object)"End AuthorizationGrant clean up", new Object[0]);
    }

    private void processRegisteredClients() {
        this.log.debug((Object)"Start Client clean up", new Object[0]);
        List<Client> clientList = this.clientService.getClientsWithExpirationDate(new String[]{"inum", "oxAuthClientSecretExpiresAt"});
        if (clientList != null && !clientList.isEmpty()) {
            for (Client client : clientList) {
                GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                expirationDate.setTime(client.getClientSecretExpiresAt());
                if (!expirationDate.before(now)) continue;
                List<AuthorizationGrant> toRemove = this.authorizationGrantList.getAuthorizationGrant(client.getClientId());
                this.authorizationGrantList.removeAuthorizationGrants(toRemove);
                this.log.debug((Object)"Removing Client: {0}, Expiration date: {1}", new Object[]{client.getClientId(), client.getClientSecretExpiresAt()});
                this.clientService.remove(client);
            }
        }
        this.log.debug((Object)"End Client clean up", new Object[0]);
    }

    private void processU2fRequests() {
        this.log.debug((Object)"Start U2F request clean up", new Object[0]);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(13, -90);
        Date expirationDate = calendar.getTime();
        List<RequestMessageLdap> expiredRequestMessage = this.u2fRequestService.getExpiredRequestMessages(expirationDate);
        if (expiredRequestMessage != null && !expiredRequestMessage.isEmpty()) {
            for (RequestMessageLdap requestMessageLdap : expiredRequestMessage) {
                this.log.debug((Object)"Removing RequestMessageLdap: {0}, Creation date: {1}", new Object[]{requestMessageLdap.getRequestId(), requestMessageLdap.getCreationDate()});
                this.u2fRequestService.removeRequestMessage(requestMessageLdap);
            }
        }
        this.log.debug((Object)"End U2F request clean up", new Object[0]);
    }

    private void processU2fDeviceRegistrations() {
        this.log.debug((Object)"Start U2F request clean up", new Object[0]);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(13, -90);
        Date expirationDate = calendar.getTime();
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.getExpiredDeviceRegistrations(expirationDate);
        if (deviceRegistrations != null && !deviceRegistrations.isEmpty()) {
            for (DeviceRegistration deviceRegistration : deviceRegistrations) {
                this.log.debug((Object)"Removing DeviceRegistration: {0}, Creation date: {1}", new Object[]{deviceRegistration.getId(), deviceRegistration.getCreationDate()});
                this.deviceRegistrationService.removeUserDeviceRegistration(deviceRegistration);
            }
        }
        this.log.debug((Object)"End U2F request clean up", new Object[0]);
    }

    private void processMetricEntries() {
        this.log.debug((Object)"Start metric entries clean up", new Object[0]);
        int keepDataDays = ConfigurationFactory.instance().getConfiguration().getMetricReporterKeepDataDays();
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(5, -keepDataDays);
        Date expirationDate = calendar.getTime();
        this.metricService.removeExpiredMetricEntries(expirationDate, ApplicationType.OX_AUTH, this.metricService.applianceInum());
        this.log.debug((Object)"End metric entries clean up", new Object[0]);
    }
}

