/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;
import org.xdi.model.SmtpConfiguration;
import org.xdi.oxauth.crypto.random.RandomChallengeGenerator;
import org.xdi.oxauth.crypto.signature.SHA256withECDSASignatureVerification;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.service.ApplianceService;
import org.xdi.oxauth.service.EncryptionService;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="applicationFactory")
@Startup
public class ApplicationFactory {
    @In
    private ApplianceService applianceService;
    @Logger
    private Log log;

    @Factory(value="randomChallengeGenerator", scope=ScopeType.APPLICATION, autoCreate=true)
    public RandomChallengeGenerator createRandomChallengeGenerator() {
        return new RandomChallengeGenerator();
    }

    @Factory(value="sha256withECDSASignatureVerification", scope=ScopeType.APPLICATION, autoCreate=true)
    public SHA256withECDSASignatureVerification createBouncyCastleSignatureVerification() {
        return new SHA256withECDSASignatureVerification();
    }

    @Factory(value="smtpConfiguration", scope=ScopeType.APPLICATION, autoCreate=true)
    public SmtpConfiguration createSmtpConfiguration() {
        GluuAppliance appliance = this.applianceService.getAppliance();
        SmtpConfiguration smtpConfiguration = appliance.getSmtpConfiguration();
        if (smtpConfiguration == null) {
            return null;
        }
        String password = smtpConfiguration.getPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                EncryptionService securityService = EncryptionService.instance();
                smtpConfiguration.setPasswordDecrypted(securityService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error((Object)"Failed to decript SMTP user password", (Throwable)ex, new Object[0]);
            }
        }
        return smtpConfiguration;
    }
}

