/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.ResultCode;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.exception.ConfigurationException;
import org.xdi.model.SimpleProperty;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.ldap.GluuLdapConfiguration;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.config.oxIDPAuthConf;
import org.xdi.oxauth.model.util.SecurityProviderUtility;
import org.xdi.oxauth.service.ApplianceService;
import org.xdi.oxauth.service.EncryptionService;
import org.xdi.oxauth.service.custom.CustomScriptManagerMigrator;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.service.PythonService;
import org.xdi.service.custom.script.CustomScriptManager;
import org.xdi.service.ldap.LdapConnectionService;
import org.xdi.util.StringHelper;
import org.xdi.util.properties.FileConfiguration;
import org.xdi.util.security.StringEncrypter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="appInitializer")
@Startup
public class AppInitializer {
    private static final String EVENT_TYPE = "AppInitializerTimerEvent";
    private static final int DEFAULT_INTERVAL = 30;
    public static final String DEFAULT_AUTH_MODE_NAME = "defaultAuthModeName";
    public static final String LDAP_AUTH_CONFIG_NAME = "ldapAuthConfig";
    public static final String LDAP_ENTRY_MANAGER_NAME = "ldapEntryManager";
    public static final String LDAP_AUTH_ENTRY_MANAGER_NAME = "ldapAuthEntryManager";
    @Logger
    private Log log;
    @In
    private ApplianceService applianceService;
    @In
    private ConfigurationFactory configurationFactory;
    private FileConfiguration ldapConfig;
    private List<GluuLdapConfiguration> ldapAuthConfigs;
    private LdapConnectionService connectionProvider;
    private LdapConnectionService bindConnectionProvider;
    private List<LdapConnectionService> authConnectionProviders;
    private List<LdapConnectionService> authBindConnectionProviders;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    @Create
    public void createApplicationComponents() {
        SecurityProviderUtility.installBCProvider();
        this.createStringEncrypter();
        this.createConnectionProvider();
        this.configurationFactory.create();
        LdapEntryManager localLdapEntryManager = (LdapEntryManager)Component.getInstance((String)LDAP_ENTRY_MANAGER_NAME, (boolean)true);
        List<GluuLdapConfiguration> ldapAuthConfigs = this.loadLdapAuthConfigs(localLdapEntryManager);
        this.createAuthConnectionProviders(ldapAuthConfigs);
        this.setDefaultAuthenticationMethod(localLdapEntryManager);
        this.addSecurityProviders();
        PythonService.instance().initPythonInterpreter();
    }

    @Observer(value={"org.jboss.seam.postInitialization"})
    @Asynchronous
    public void postInitialization() {
        List<CustomScriptType> supportedCustomScriptTypes = Arrays.asList(CustomScriptType.PERSON_AUTHENTICATION, CustomScriptType.CLIENT_REGISTRATION, CustomScriptType.ID_GENERATOR, CustomScriptType.UMA_AUTHORIZATION_POLICY, CustomScriptType.APPLICATION_SESSION, CustomScriptType.DYNAMIC_SCOPE);
        CustomScriptManager.instance().init(supportedCustomScriptTypes);
        CustomScriptManagerMigrator.instance().migrateOldConfigurations();
    }

    private void createStringEncrypter() {
        String encodeSalt = this.configurationFactory.getCryptoConfigurationSalt();
        if (StringHelper.isEmpty((String)encodeSalt)) {
            throw new ConfigurationException("Encode salt isn't defined");
        }
        try {
            StringEncrypter stringEncrypter = StringEncrypter.instance((String)encodeSalt);
            Context applicationContext = Contexts.getApplicationContext();
            applicationContext.set("stringEncrypter", (Object)stringEncrypter);
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ConfigurationException("Failed to create StringEncrypter instance");
        }
    }

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void initReloadTimer() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(30000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"AppInitializerTimerEvent"})
    @Asynchronous
    public void reloadConfigurationTimerEvent() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error((Object)"Exception happened while reloading application configuration", ex, new Object[0]);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
        }
    }

    private void reloadConfiguration() {
        LdapEntryManager localLdapEntryManager = (LdapEntryManager)Component.getInstance((String)LDAP_ENTRY_MANAGER_NAME, (boolean)true);
        List<GluuLdapConfiguration> newLdapAuthConfigs = this.loadLdapAuthConfigs(localLdapEntryManager);
        if (!this.ldapAuthConfigs.equals(newLdapAuthConfigs)) {
            this.recreateLdapAuthEntryManagers(newLdapAuthConfigs);
        }
        this.setDefaultAuthenticationMethod(localLdapEntryManager);
    }

    private void addSecurityProviders() {
        try {
            Provider[] providers = Security.getProviders();
            if (providers != null) {
                boolean hasBC = false;
                for (Provider p : providers) {
                    if (!p.getName().equalsIgnoreCase("BC")) continue;
                    hasBC = true;
                }
                if (!hasBC) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                }
            }
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Factory(value="ldapEntryManager", scope=ScopeType.APPLICATION, autoCreate=true)
    public LdapEntryManager createLdapEntryManager() {
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.connectionProvider, (LDAPConnectionProvider)this.bindConnectionProvider));
        this.log.debug((Object)"Created {0}: {1}", new Object[]{LDAP_ENTRY_MANAGER_NAME, ldapEntryManager});
        return ldapEntryManager;
    }

    @Factory(value="ldapAuthEntryManager", scope=ScopeType.APPLICATION, autoCreate=true)
    public List<LdapEntryManager> createLdapAuthEntryManager() {
        ArrayList<LdapEntryManager> ldapAuthEntryManagers = new ArrayList<LdapEntryManager>();
        if (this.ldapAuthConfigs.size() == 0) {
            return ldapAuthEntryManagers;
        }
        for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
            LdapEntryManager ldapAuthEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.authConnectionProviders.get(i), (LDAPConnectionProvider)this.authBindConnectionProviders.get(i)));
            this.log.debug((Object)"Created {0}#{1}: {2}", new Object[]{LDAP_AUTH_ENTRY_MANAGER_NAME, i, ldapAuthEntryManager});
            ldapAuthEntryManagers.add(ldapAuthEntryManager);
        }
        return ldapAuthEntryManagers;
    }

    @Observer(value={"LDAP_CONFIGUARION_RELOAD"})
    public void recreateLdapEntryManager() {
        LdapEntryManager oldLdapEntryManager = (LdapEntryManager)Component.getInstance((String)LDAP_ENTRY_MANAGER_NAME);
        this.createConnectionProvider();
        Contexts.getApplicationContext().remove(LDAP_ENTRY_MANAGER_NAME);
        oldLdapEntryManager.destroy();
        this.log.debug((Object)"Destroyed {0}: {1}", new Object[]{LDAP_ENTRY_MANAGER_NAME, oldLdapEntryManager});
    }

    public void recreateLdapAuthEntryManagers(List<GluuLdapConfiguration> newLdapAuthConfigs) {
        List oldLdapAuthEntryManagers = (List)Component.getInstance((String)LDAP_AUTH_ENTRY_MANAGER_NAME);
        this.createAuthConnectionProviders(newLdapAuthConfigs);
        Contexts.getApplicationContext().remove(LDAP_AUTH_ENTRY_MANAGER_NAME);
        for (LdapEntryManager oldLdapAuthEntryManager : oldLdapAuthEntryManagers) {
            oldLdapAuthEntryManager.destroy();
            this.log.debug((Object)"Destroyed {0}: {1}", new Object[]{LDAP_AUTH_ENTRY_MANAGER_NAME, oldLdapAuthEntryManager});
        }
    }

    private void destroyLdapConnectionService(LdapConnectionService connectionProvider) {
        if (connectionProvider != null) {
            connectionProvider.closeConnectionPool();
            this.log.debug((Object)"Destoryed connectionProvider: {1}", new Object[]{connectionProvider});
        }
    }

    private void createConnectionProvider() {
        this.ldapConfig = this.configurationFactory.getLdapConfiguration();
        Properties connectionProperties = this.ldapConfig.getProperties();
        this.connectionProvider = this.createConnectionProvider(connectionProperties);
        Properties bindConnectionProperties = this.prepareBindConnectionProperties(connectionProperties);
        this.bindConnectionProvider = this.createBindConnectionProvider(bindConnectionProperties, connectionProperties);
    }

    private void createAuthConnectionProviders(List<GluuLdapConfiguration> newLdapAuthConfigs) {
        ArrayList<LdapConnectionService> tmpAuthConnectionProviders = new ArrayList<LdapConnectionService>();
        ArrayList<LdapConnectionService> tmpAuthBindConnectionProviders = new ArrayList<LdapConnectionService>();
        for (GluuLdapConfiguration ldapAuthConfig : newLdapAuthConfigs) {
            LdapConnectionProviders ldapConnectionProviders = this.createAuthConnectionProviders(ldapAuthConfig);
            tmpAuthConnectionProviders.add(ldapConnectionProviders.getConnectionProvider());
            tmpAuthBindConnectionProviders.add(ldapConnectionProviders.getConnectionBindProvider());
        }
        this.ldapAuthConfigs = newLdapAuthConfigs;
        Contexts.getApplicationContext().set(LDAP_AUTH_CONFIG_NAME, newLdapAuthConfigs);
        this.authConnectionProviders = tmpAuthConnectionProviders;
        this.authBindConnectionProviders = tmpAuthBindConnectionProviders;
    }

    public LdapConnectionProviders createAuthConnectionProviders(GluuLdapConfiguration ldapAuthConfig) {
        Properties connectionProperties = this.prepareAuthConnectionProperties(ldapAuthConfig);
        LdapConnectionService connectionProvider = this.createConnectionProvider(connectionProperties);
        Properties bindConnectionProperties = this.prepareBindConnectionProperties(connectionProperties);
        LdapConnectionService bindConnectionProvider = this.createBindConnectionProvider(bindConnectionProperties, connectionProperties);
        return new LdapConnectionProviders(connectionProvider, bindConnectionProvider);
    }

    private Properties prepareAuthConnectionProperties(GluuLdapConfiguration ldapAuthConfig) {
        FileConfiguration configuration = this.configurationFactory.getLdapConfiguration();
        Properties properties = (Properties)configuration.getProperties().clone();
        if (ldapAuthConfig != null) {
            properties.setProperty("servers", this.buildServersString(ldapAuthConfig.getServers()));
            String bindDn = ldapAuthConfig.getBindDN();
            if (StringHelper.isNotEmpty((String)bindDn)) {
                properties.setProperty("bindDN", bindDn);
                properties.setProperty("bindPassword", ldapAuthConfig.getBindPassword());
            }
            properties.setProperty("useSSL", Boolean.toString(ldapAuthConfig.isUseSSL()));
            properties.setProperty("maxconnections", Integer.toString(ldapAuthConfig.getMaxConnections()));
        }
        return properties;
    }

    private Properties prepareBindConnectionProperties(Properties connectionProperties) {
        Properties bindProperties = (Properties)connectionProperties.clone();
        return bindProperties;
    }

    private LdapConnectionService createConnectionProvider(Properties connectionProperties) {
        EncryptionService securityService = EncryptionService.instance();
        LdapConnectionService connectionProvider = new LdapConnectionService(securityService.decryptProperties(connectionProperties));
        return connectionProvider;
    }

    private LdapConnectionService createBindConnectionProvider(Properties bindConnectionProperties, Properties connectionProperties) {
        LdapConnectionService bindConnectionProvider = this.createConnectionProvider(bindConnectionProperties);
        if (ResultCode.INAPPROPRIATE_AUTHENTICATION.equals((Object)bindConnectionProvider.getCreationResultCode())) {
            this.log.warn((Object)"It's not possible to create authentication LDAP connection pool using anonymous bind. Attempting to create it using binDN/bindPassword", new Object[0]);
            bindConnectionProvider = this.createConnectionProvider(connectionProperties);
        }
        return bindConnectionProvider;
    }

    private String buildServersString(List<?> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers == null) {
            return sb.toString();
        }
        boolean first = true;
        for (Object server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (server instanceof SimpleProperty) {
                sb.append(((SimpleProperty)server).getValue());
                continue;
            }
            sb.append(server);
        }
        return sb.toString();
    }

    private List<oxIDPAuthConf> loadLdapIdpAuthConfigs(LdapEntryManager localLdapEntryManager) {
        GluuAppliance appliance = this.loadAppliance(localLdapEntryManager, "oxIDPAuthentication");
        if (appliance == null || appliance.getOxIDPAuthentication() == null) {
            return null;
        }
        ArrayList<oxIDPAuthConf> configurations = new ArrayList<oxIDPAuthConf>();
        for (String configurationJson : appliance.getOxIDPAuthentication()) {
            try {
                oxIDPAuthConf configuration = (oxIDPAuthConf)this.jsonToObject(configurationJson, oxIDPAuthConf.class);
                if (!configuration.getType().equalsIgnoreCase("ldap") && !configuration.getType().equalsIgnoreCase("auth")) continue;
                configurations.add(configuration);
            }
            catch (Exception ex) {
                this.log.error((Object)"Failed to create object by json: '{0}'", (Throwable)ex, new Object[]{configurationJson});
            }
        }
        return configurations;
    }

    private void setDefaultAuthenticationMethod(LdapEntryManager localLdapEntryManager) {
        GluuAppliance appliance = this.loadAppliance(localLdapEntryManager, "oxAuthenticationMode");
        String authenticationMode = null;
        if (appliance != null) {
            authenticationMode = appliance.getAuthenticationMode();
        }
        Contexts.getApplicationContext().set(DEFAULT_AUTH_MODE_NAME, (Object)authenticationMode);
    }

    private GluuAppliance loadAppliance(LdapEntryManager localLdapEntryManager, String ... ldapReturnAttributes) {
        String baseDn = ConfigurationFactory.instance().getBaseDn().getAppliance();
        String applianceInum = ConfigurationFactory.instance().getConfiguration().getApplianceInum();
        if (StringHelper.isEmpty((String)baseDn) || StringHelper.isEmpty((String)applianceInum)) {
            return null;
        }
        String applianceDn = String.format("inum=%s,%s", applianceInum, baseDn);
        GluuAppliance appliance = null;
        try {
            appliance = (GluuAppliance)localLdapEntryManager.find(GluuAppliance.class, (Object)applianceDn, ldapReturnAttributes);
        }
        catch (LdapMappingException ex) {
            this.log.error((Object)"Failed to load appliance entry from Ldap", (Throwable)ex, new Object[0]);
            return null;
        }
        return appliance;
    }

    public GluuLdapConfiguration loadLdapAuthConfig(oxIDPAuthConf configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            if (configuration.getType().equalsIgnoreCase("ldap")) {
                return this.mapOldLdapConfig(configuration);
            }
            if (configuration.getType().equalsIgnoreCase("auth")) {
                return this.mapLdapConfig(configuration.getConfig());
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to create object by oxIDPAuthConf: '{0}'", (Throwable)ex, new Object[]{configuration});
        }
        return null;
    }

    private List<GluuLdapConfiguration> loadLdapAuthConfigs(LdapEntryManager localLdapEntryManager) {
        ArrayList<GluuLdapConfiguration> ldapAuthConfigs = new ArrayList<GluuLdapConfiguration>();
        List<oxIDPAuthConf> ldapIdpAuthConfigs = this.loadLdapIdpAuthConfigs(localLdapEntryManager);
        if (ldapIdpAuthConfigs == null) {
            return ldapAuthConfigs;
        }
        for (oxIDPAuthConf ldapIdpAuthConfig : ldapIdpAuthConfigs) {
            GluuLdapConfiguration ldapAuthConfig = this.loadLdapAuthConfig(ldapIdpAuthConfig);
            if (ldapAuthConfig == null) continue;
            ldapAuthConfigs.add(ldapAuthConfig);
        }
        return ldapAuthConfigs;
    }

    @Deprecated
    private GluuLdapConfiguration mapOldLdapConfig(oxIDPAuthConf oneConf) {
        GluuLdapConfiguration ldapConfig = new GluuLdapConfiguration();
        ldapConfig.setServers(Arrays.asList(new SimpleProperty(oneConf.getFields().get(0).getValues().get(0) + ":" + oneConf.getFields().get(1).getValues().get(0))));
        ldapConfig.setBindDN(oneConf.getFields().get(2).getValues().get(0));
        ldapConfig.setBindPassword(oneConf.getFields().get(3).getValues().get(0));
        ldapConfig.setUseSSL(Boolean.valueOf(oneConf.getFields().get(4).getValues().get(0)).booleanValue());
        ldapConfig.setMaxConnections(3);
        ldapConfig.setConfigId("auth_ldap_server");
        ldapConfig.setEnabled(oneConf.getEnabled());
        return ldapConfig;
    }

    private GluuLdapConfiguration mapLdapConfig(String config) throws Exception {
        return (GluuLdapConfiguration)this.jsonToObject(config, GluuLdapConfiguration.class);
    }

    private Object jsonToObject(String json, Class<?> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Object clazzObject = mapper.readValue(json, clazz);
        return clazzObject;
    }

    public static AppInitializer instance() {
        return (AppInitializer)ServerUtil.instance(AppInitializer.class);
    }

    private class LdapConnectionProviders {
        private LdapConnectionService connectionProvider;
        private LdapConnectionService connectionBindProvider;

        public LdapConnectionProviders(LdapConnectionService connectionProvider, LdapConnectionService connectionBindProvider) {
            this.connectionProvider = connectionProvider;
            this.connectionBindProvider = connectionBindProvider;
        }

        public LdapConnectionService getConnectionProvider() {
            return this.connectionProvider;
        }

        public LdapConnectionService getConnectionBindProvider() {
            return this.connectionBindProvider;
        }
    }
}

