/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.register.ws.rs;

import com.codahale.metrics.Timer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.model.metric.MetricType;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.registration.RegisterParamsValidator;
import org.xdi.oxauth.model.token.HandleTokenFactory;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.register.ws.rs.RegisterRestWebService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.InumService;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.external.ExternalDynamicClientRegistrationService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.security.StringEncrypter;

@Name(value="registerRestWebService")
public class RegisterRestWebServiceImpl
implements RegisterRestWebService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private ScopeService scopeService;
    @In
    private InumService inumService;
    @In
    private ClientService clientService;
    @In
    private TokenService tokenService;
    @In
    private MetricService metricService;
    @In
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response requestRegister(String requestParams, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        Timer.Context timerContext = this.metricService.getTimer(MetricType.DYNAMIC_CLIENT_REGISTRATION_RATE).time();
        try {
            Response response = this.registerClientImpl(requestParams, securityContext);
            return response;
        }
        finally {
            timerContext.stop();
        }
    }

    private Response registerClientImpl(String requestParams, SecurityContext securityContext) {
        Response.ResponseBuilder builder;
        block17: {
            builder = Response.ok();
            try {
                RegisterRequest r = RegisterRequest.fromJson((String)requestParams);
                if (r.getSubjectType() == null) {
                    if (ConfigurationFactory.instance().getConfiguration().getSubjectTypesSupported().contains(SubjectType.PUBLIC.toString())) {
                        r.setSubjectType(SubjectType.PUBLIC);
                    } else if (ConfigurationFactory.instance().getConfiguration().getSubjectTypesSupported().contains(SubjectType.PAIRWISE.toString())) {
                        r.setSubjectType(SubjectType.PAIRWISE);
                    }
                }
                if (r.getIdTokenSignedResponseAlg() == null) {
                    r.setIdTokenSignedResponseAlg(SignatureAlgorithm.fromName((String)ConfigurationFactory.instance().getConfiguration().getDefaultSignatureAlgorithm()));
                }
                this.log.debug((Object)"Attempting to register client: applicationType = {0}, clientName = {1}, redirectUris = {2}, isSecure = {3}, sectorIdentifierUri = {4}, params = {5}", new Object[]{r.getApplicationType(), r.getClientName(), r.getRedirectUris(), securityContext.isSecure(), r.getSectorIdentifierUri(), requestParams});
                if (ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationEnabled().booleanValue()) {
                    if (RegisterParamsValidator.validateParamsClientRegister(r.getApplicationType(), r.getSubjectType(), r.getRedirectUris(), r.getSectorIdentifierUri())) {
                        if (!RegisterParamsValidator.validateRedirectUris(r.getApplicationType(), r.getSubjectType(), r.getRedirectUris(), r.getSectorIdentifierUri())) {
                            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_REDIRECT_URI));
                            break block17;
                        }
                        RegisterParamsValidator.validateLogoutUri(r.getLogoutUri(), r.getRedirectUris(), this.errorResponseFactory);
                        String clientsBaseDN = ConfigurationFactory.instance().getBaseDn().getClients();
                        String inum = this.inumService.generateClientInum();
                        String generatedClientSecret = UUID.randomUUID().toString();
                        String[] scopes = new String[]{};
                        scopes = ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationScopesParamEnabled() != null && ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationScopesParamEnabled() != false && r.getScopes().size() > 0 ? this.scopeService.getScopesDn(r.getScopes()).toArray(scopes) : this.scopeService.getDefaultScopesDn().toArray(scopes);
                        Client client = new Client();
                        client.setDn("inum=" + inum + "," + clientsBaseDN);
                        client.setClientId(inum);
                        client.setClientSecret(generatedClientSecret);
                        client.setScopes(scopes);
                        client.setRegistrationAccessToken(HandleTokenFactory.generateHandleToken());
                        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                        client.setClientIdIssuedAt(calendar.getTime());
                        if (ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationExpirationTime() > 0) {
                            ((Calendar)calendar).add(13, ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationExpirationTime());
                            client.setClientSecretExpiresAt(calendar.getTime());
                        }
                        if (StringUtils.isBlank((String)r.getClientName()) && r.getRedirectUris() != null && !r.getRedirectUris().isEmpty()) {
                            try {
                                URI redUri = new URI((String)r.getRedirectUris().get(0));
                                client.setClientName(redUri.getHost());
                            }
                            catch (Exception e) {
                                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                                client.setClientName("Unknown");
                            }
                        }
                        RegisterRestWebServiceImpl.updateClientFromRequestObject(client, r);
                        if (this.externalDynamicClientRegistrationService.isEnabled()) {
                            this.externalDynamicClientRegistrationService.executeExternalUpdateClientMethods(r, client);
                        }
                        Date currentTime = Calendar.getInstance().getTime();
                        client.setLastAccessTime(currentTime);
                        client.setLastLogonTime(currentTime);
                        Boolean persistClientAuthorizations = ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationPersistClientAuthorizations();
                        client.setPersistClientAuthorizations(persistClientAuthorizations != null ? persistClientAuthorizations : false);
                        this.clientService.persist(client);
                        JSONObject jsonObject = this.getJSONObject(client);
                        builder.entity((Object)jsonObject.toString(4).replace("\\/", "/"));
                        break block17;
                    }
                    this.log.trace((Object)"Client parameters are invalid, returns invalid_request error.", new Object[0]);
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
                    break block17;
                }
                this.log.debug((Object)"Dynamic client registration is disabled.", new Object[0]);
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.ACCESS_DENIED));
            }
            catch (StringEncrypter.EncryptionException e) {
                builder = this.internalErrorResponse();
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (JSONException e) {
                builder = this.internalErrorResponse();
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (Exception e) {
                builder = this.internalErrorResponse();
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        return builder.build();
    }

    public Response.ResponseBuilder internalErrorResponse() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
    }

    public static void updateClientFromRequestObject(Client p_client, RegisterRequest requestObject) throws JSONException {
        ArrayList postLogoutRedirectUris;
        ArrayList defaultAcrValues;
        ArrayList contacts;
        ArrayList responseTypes;
        ArrayList redirectUris = requestObject.getRedirectUris();
        if (redirectUris != null && !redirectUris.isEmpty()) {
            redirectUris = new ArrayList(new HashSet(redirectUris));
            p_client.setRedirectUris(redirectUris.toArray(new String[redirectUris.size()]));
        }
        if (requestObject.getApplicationType() != null) {
            p_client.setApplicationType(requestObject.getApplicationType().toString());
        }
        if (StringUtils.isNotBlank((String)requestObject.getClientName())) {
            p_client.setClientName(requestObject.getClientName());
        }
        if (StringUtils.isNotBlank((String)requestObject.getSectorIdentifierUri())) {
            p_client.setSectorIdentifierUri(requestObject.getSectorIdentifierUri());
        }
        if ((responseTypes = requestObject.getResponseTypes()) != null && !responseTypes.isEmpty()) {
            responseTypes = new ArrayList(new HashSet(responseTypes));
            p_client.setResponseTypes(responseTypes.toArray(new ResponseType[responseTypes.size()]));
        }
        if ((contacts = requestObject.getContacts()) != null && !contacts.isEmpty()) {
            contacts = new ArrayList(new HashSet(contacts));
            p_client.setContacts(contacts.toArray(new String[contacts.size()]));
        }
        if (StringUtils.isNotBlank((String)requestObject.getLogoUri())) {
            p_client.setLogoUri(requestObject.getLogoUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getClientUri())) {
            p_client.setClientUri(requestObject.getClientUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getPolicyUri())) {
            p_client.setPolicyUri(requestObject.getPolicyUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getTosUri())) {
            p_client.setTosUri(requestObject.getTosUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getJwksUri())) {
            p_client.setJwksUri(requestObject.getJwksUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getJwks())) {
            p_client.setJwks(requestObject.getJwks());
        }
        if (requestObject.getSubjectType() != null) {
            p_client.setSubjectType(requestObject.getSubjectType().toString());
        }
        if (requestObject.getIdTokenSignedResponseAlg() != null) {
            p_client.setIdTokenSignedResponseAlg(requestObject.getIdTokenSignedResponseAlg().toString());
        }
        if (requestObject.getIdTokenEncryptedResponseAlg() != null) {
            p_client.setIdTokenEncryptedResponseAlg(requestObject.getIdTokenEncryptedResponseAlg().toString());
        }
        if (requestObject.getIdTokenEncryptedResponseEnc() != null) {
            p_client.setIdTokenEncryptedResponseEnc(requestObject.getIdTokenEncryptedResponseEnc().toString());
        }
        if (requestObject.getUserInfoSignedResponseAlg() != null) {
            p_client.setUserInfoSignedResponseAlg(requestObject.getUserInfoSignedResponseAlg().toString());
        }
        if (requestObject.getUserInfoEncryptedResponseAlg() != null) {
            p_client.setUserInfoEncryptedResponseAlg(requestObject.getUserInfoEncryptedResponseAlg().toString());
        }
        if (requestObject.getUserInfoEncryptedResponseEnc() != null) {
            p_client.setUserInfoEncryptedResponseEnc(requestObject.getUserInfoEncryptedResponseEnc().toString());
        }
        if (requestObject.getRequestObjectSigningAlg() != null) {
            p_client.setRequestObjectSigningAlg(requestObject.getRequestObjectSigningAlg().toString());
        }
        if (requestObject.getRequestObjectEncryptionAlg() != null) {
            p_client.setRequestObjectEncryptionAlg(requestObject.getRequestObjectEncryptionAlg().toString());
        }
        if (requestObject.getRequestObjectEncryptionEnc() != null) {
            p_client.setRequestObjectEncryptionEnc(requestObject.getRequestObjectEncryptionEnc().toString());
        }
        if (requestObject.getTokenEndpointAuthMethod() != null) {
            p_client.setTokenEndpointAuthMethod(requestObject.getTokenEndpointAuthMethod().toString());
        } else {
            p_client.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        }
        if (requestObject.getTokenEndpointAuthSigningAlg() != null) {
            p_client.setTokenEndpointAuthSigningAlg(requestObject.getTokenEndpointAuthSigningAlg().toString());
        }
        if (requestObject.getDefaultMaxAge() != null) {
            p_client.setDefaultMaxAge(requestObject.getDefaultMaxAge());
        }
        if (requestObject.getRequireAuthTime() != null) {
            p_client.setRequireAuthTime(requestObject.getRequireAuthTime());
        }
        if ((defaultAcrValues = requestObject.getDefaultAcrValues()) != null && !defaultAcrValues.isEmpty()) {
            defaultAcrValues = new ArrayList(new HashSet(defaultAcrValues));
            p_client.setDefaultAcrValues(defaultAcrValues.toArray(new String[defaultAcrValues.size()]));
        }
        if (StringUtils.isNotBlank((String)requestObject.getInitiateLoginUri())) {
            p_client.setInitiateLoginUri(requestObject.getInitiateLoginUri());
        }
        if ((postLogoutRedirectUris = requestObject.getPostLogoutRedirectUris()) != null && !postLogoutRedirectUris.isEmpty()) {
            postLogoutRedirectUris = new ArrayList(new HashSet(postLogoutRedirectUris));
            p_client.setPostLogoutRedirectUris(postLogoutRedirectUris.toArray(new String[postLogoutRedirectUris.size()]));
        }
        if (StringUtils.isNotBlank((String)requestObject.getLogoutUri())) {
            p_client.setLogoutUri(requestObject.getLogoutUri());
        }
        p_client.setLogoutSessionRequired(requestObject.getLogoutSessionRequired());
        ArrayList requestUris = requestObject.getRequestUris();
        if (requestUris != null && !requestUris.isEmpty()) {
            requestUris = new ArrayList(new HashSet(requestUris));
            p_client.setRequestUris(requestUris.toArray(new String[requestUris.size()]));
        }
        if (StringUtils.isNotBlank((String)requestObject.getFederationUrl())) {
            p_client.setFederationURI(requestObject.getFederationUrl());
        }
        if (StringUtils.isNotBlank((String)requestObject.getFederationId())) {
            p_client.setFederationId(requestObject.getFederationId());
        }
        if (requestObject.getJsonObject() != null) {
            RegisterRestWebServiceImpl.putCustomStuffIntoObject(p_client, requestObject.getJsonObject());
        }
    }

    @Override
    public Response requestClientUpdate(String requestParams, String clientId, @HeaderParam(value="Authorization") String authorization, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        try {
            RegisterRequest request;
            this.log.debug((Object)"Attempting to UPDATE client, client_id: {0}, requestParams = {1}, isSecure = {3}", new Object[]{clientId, requestParams, securityContext.isSecure()});
            String accessToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
            if (StringUtils.isNotBlank((String)accessToken) && StringUtils.isNotBlank((String)clientId) && StringUtils.isNotBlank((String)requestParams) && (request = RegisterRequest.fromJson((String)requestParams)) != null) {
                if (request.getSubjectType() != null && !ConfigurationFactory.instance().getConfiguration().getSubjectTypesSupported().contains(request.getSubjectType())) {
                    this.log.debug((Object)"Client UPDATE : parameter subject_type is invalid. Returns BAD_REQUEST response.", new Object[0]);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA)).build();
                }
                Client client = this.clientService.getClient(clientId, accessToken);
                if (client != null) {
                    RegisterRestWebServiceImpl.updateClientFromRequestObject(client, request);
                    this.clientService.merge(client);
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)this.clientAsEntity(client)).build();
                }
                this.log.trace((Object)"The Access Token is not valid for the Client ID, returns invalid_token error.", new Object[0]);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN)).build();
            }
            this.log.debug((Object)"Client UPDATE : parameters are invalid. Returns BAD_REQUEST response.", new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA)).build();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return this.internalErrorResponse().build();
        }
    }

    @Override
    public Response requestClientRead(String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        String accessToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        this.log.debug((Object)"Attempting to read client: clientId = {0}, registrationAccessToken = {1} isSecure = {2}", new Object[]{clientId, accessToken, securityContext.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        try {
            if (ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationEnabled().booleanValue()) {
                if (RegisterParamsValidator.validateParamsClientRead(clientId, accessToken)) {
                    Client client = this.clientService.getClient(clientId, accessToken);
                    if (client != null) {
                        builder.entity((Object)this.clientAsEntity(client));
                    } else {
                        this.log.trace((Object)"The Access Token is not valid for the Client ID, returns invalid_token error.", new Object[0]);
                        builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                        builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN));
                    }
                } else {
                    this.log.trace((Object)"Client parameters are invalid.", new Object[0]);
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
                }
            } else {
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.ACCESS_DENIED));
            }
        }
        catch (JSONException e) {
            builder = Response.status((int)500);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (StringEncrypter.EncryptionException e) {
            builder = Response.status((int)500);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        cacheControl.setNoStore(true);
        builder.cacheControl(cacheControl);
        builder.header("Pragma", (Object)"no-cache");
        return builder.build();
    }

    private String clientAsEntity(Client p_client) throws JSONException, StringEncrypter.EncryptionException {
        JSONObject jsonObject = this.getJSONObject(p_client);
        return jsonObject.toString(4).replace("\\/", "/");
    }

    private JSONObject getJSONObject(Client client) throws JSONException, StringEncrypter.EncryptionException {
        JSONObject responseJsonObject = new JSONObject();
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.CLIENT_ID.toString(), (Object)client.getClientId());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.CLIENT_SECRET.toString(), (Object)client.getClientSecret());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString(), (Object)client.getRegistrationAccessToken());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.REGISTRATION_CLIENT_URI.toString(), (Object)(ConfigurationFactory.instance().getConfiguration().getRegistrationEndpoint() + "?" + RegisterResponseParam.CLIENT_ID.toString() + "=" + client.getClientId()));
        responseJsonObject.put(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString(), client.getClientIdIssuedAt().getTime() / 1000L);
        responseJsonObject.put(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString(), client.getClientSecretExpiresAt() != null && client.getClientSecretExpiresAt().getTime() > 0L ? client.getClientSecretExpiresAt().getTime() / 1000L : 0L);
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REDIRECT_URIS.toString(), (String[])client.getRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.RESPONSE_TYPES.toString(), (String[])ResponseType.toStringArray((ResponseType[])client.getResponseTypes()));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.GRANT_TYPES.toString(), (String[])client.getGrantTypes());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)client.getApplicationType());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CONTACTS.toString(), (String[])client.getContacts());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_NAME.toString(), (Object)client.getClientName());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGO_URI.toString(), (Object)client.getLogoUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_URI.toString(), (Object)client.getClientUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POLICY_URI.toString(), (Object)client.getPolicyUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOS_URI.toString(), (Object)client.getTosUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.JWKS_URI.toString(), (Object)client.getJwksUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.JWKS.toString(), (Object)client.getJwks());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)client.getSectorIdentifierUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)client.getSubjectType());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)client.getIdTokenSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getIdTokenEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getIdTokenEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)client.getUserInfoSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getUserInfoEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getUserInfoEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)client.getRequestObjectSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), (Object)client.getRequestObjectEncryptionAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), (Object)client.getRequestObjectEncryptionEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)client.getTokenEndpointAuthMethod());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), (Object)client.getTokenEndpointAuthSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)client.getDefaultMaxAge());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)client.getRequireAuthTime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), (String[])client.getDefaultAcrValues());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)client.getInitiateLoginUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), (String[])client.getPostLogoutRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_URIS.toString(), (String[])client.getRequestUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGOUT_URI.toString(), (Object)client.getLogoutUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGOUT_SESSION_REQUIRED.toString(), (Object)client.getLogoutSessionRequired());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.FEDERATION_METADATA_URL.toString(), (Object)client.getFederationURI());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.FEDERATION_METADATA_ID.toString(), (Object)client.getFederationId());
        String[] scopeNames = null;
        String[] scopeDns = client.getScopes();
        if (scopeDns != null) {
            scopeNames = new String[scopeDns.length];
            for (int i = 0; i < scopeDns.length; ++i) {
                Scope scope = this.scopeService.getScopeByDn(scopeDns[i]);
                scopeNames[i] = scope.getDisplayName();
            }
        }
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)"scopes", (String[])scopeNames);
        return responseJsonObject;
    }

    private static void putCustomStuffIntoObject(Client p_client, JSONObject p_requestObject) throws JSONException {
        List<String> attrList;
        String customOC = ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationCustomObjectClass();
        if (StringUtils.isNotBlank((String)customOC)) {
            p_client.setCustomObjectClasses(new String[]{customOC});
        }
        if ((attrList = ConfigurationFactory.instance().getConfiguration().getDynamicRegistrationCustomAttributes()) != null && !attrList.isEmpty()) {
            Log staticLog = Logging.getLog(RegisterRestWebServiceImpl.class);
            for (String attr : attrList) {
                JSONArray parameterValuesJsonArray;
                List<String> parameterValues;
                if (!p_requestObject.has(attr) || (parameterValues = (parameterValuesJsonArray = p_requestObject.optJSONArray(attr)) != null ? org.xdi.oxauth.model.util.StringUtils.toList((JSONArray)parameterValuesJsonArray) : Arrays.asList(p_requestObject.getString(attr))) == null || parameterValues.isEmpty()) continue;
                try {
                    p_client.getCustomAttributes().add(new CustomAttribute(attr, parameterValues));
                }
                catch (Exception e) {
                    staticLog.debug((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
            }
        }
    }
}

