/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.token;

import java.security.SignatureException;
import java.util.List;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.HMACSigner;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.util.security.StringEncrypter;

public class JwtSigner {
    private final JSONWebKeySet jwks = ConfigurationFactory.instance().getWebKeys();
    private final Client client;
    private SignatureAlgorithm signatureAlgorithm;
    private Jwt jwt;

    public JwtSigner(Client client) {
        this.client = client;
        this.signatureAlgorithm = SignatureAlgorithm.fromName((String)ConfigurationFactory.instance().getConfiguration().getDefaultSignatureAlgorithm());
        if (client != null && client.getIdTokenSignedResponseAlg() != null) {
            this.signatureAlgorithm = SignatureAlgorithm.fromName((String)client.getIdTokenSignedResponseAlg());
        }
    }

    public Jwt newJwt() {
        this.jwt = new Jwt();
        this.jwt.getHeader().setType(JwtType.JWT);
        this.jwt.getHeader().setAlgorithm(this.signatureAlgorithm);
        List jsonWebKeys = this.jwks.getKeys(this.signatureAlgorithm);
        if (jsonWebKeys.size() > 0) {
            this.jwt.getHeader().setKeyId(((JSONWebKey)jsonWebKeys.get(0)).getKid());
        }
        this.jwt.getClaims().setIssuer(ConfigurationFactory.instance().getConfiguration().getIssuer());
        this.jwt.getClaims().setAudience(this.client.getClientId());
        return this.jwt;
    }

    public Jwt sign() throws SignatureException, InvalidJwtException, StringEncrypter.EncryptionException {
        JSONWebKey jwk = null;
        switch (this.signatureAlgorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                HMACSigner hmacSigner = new HMACSigner(this.signatureAlgorithm, this.client.getClientSecret());
                this.jwt = hmacSigner.sign(this.jwt);
                break;
            }
            case RS256: 
            case RS384: 
            case RS512: {
                jwk = this.jwks.getKey(this.jwt.getHeader().getClaimAsString("kid"));
                RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(jwk.getPrivateKey().getN(), jwk.getPrivateKey().getE());
                RSASigner rsaSigner = new RSASigner(this.signatureAlgorithm, rsaPrivateKey);
                this.jwt = rsaSigner.sign(this.jwt);
                break;
            }
            case ES256: 
            case ES384: 
            case ES512: {
                jwk = this.jwks.getKey(this.jwt.getHeader().getClaimAsString("kid"));
                ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(jwk.getPrivateKey().getD());
                ECDSASigner ecdsaSigner = new ECDSASigner(this.signatureAlgorithm, ecdsaPrivateKey);
                this.jwt = ecdsaSigner.sign(this.jwt);
                break;
            }
            case NONE: {
                break;
            }
        }
        return this.jwt;
    }

    public Client getClient() {
        return this.client;
    }

    public JSONWebKeySet getJwks() {
        return this.jwks;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }
}

