/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.registration;

import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

public class RegisterParamsValidator {
    private static final Log LOG = Logging.getLog(RegisterParamsValidator.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String LOCALHOST = "localhost";

    public static boolean validateParamsClientRegister(ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        boolean validParams;
        boolean bl = validParams = applicationType != null && redirectUris != null && !redirectUris.isEmpty();
        if (subjectType == null || !ConfigurationFactory.instance().getConfiguration().getSubjectTypesSupported().contains(subjectType.toString())) {
            LOG.debug((Object)"Parameter subject_type is not valid.", new Object[0]);
            return false;
        }
        if (validParams && StringUtils.isNotBlank((String)sectorIdentifierUrl)) {
            try {
                URI uri = new URI(sectorIdentifierUrl);
                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                    return false;
                }
                ClientRequest clientRequest = new ClientRequest(sectorIdentifierUrl);
                clientRequest.setHttpMethod("GET");
                ClientResponse clientResponse = clientRequest.get(String.class);
                int status = clientResponse.getStatus();
                if (status == 200) {
                    String entity = (String)clientResponse.getEntity(String.class);
                    JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                    return Util.asList((JSONArray)sectorIdentifierJsonArray).containsAll(redirectUris);
                }
            }
            catch (URISyntaxException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (UnknownHostException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (ConnectException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (JSONException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (Exception e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
        }
        return validParams;
    }

    public static boolean validateParamsClientRead(String clientId, String accessToken) {
        return StringUtils.isNotBlank((String)clientId) && StringUtils.isNotBlank((String)accessToken);
    }

    public static boolean validateRedirectUris(ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        HashSet<String> redirectUriHosts;
        block11: {
            redirectUriHosts = new HashSet<String>();
            try {
                if (redirectUris != null && !redirectUris.isEmpty()) {
                    for (String redirectUri : redirectUris) {
                        if (redirectUri == null || redirectUri.contains("#")) {
                            return false;
                        }
                        URI uri = new URI(redirectUri);
                        redirectUriHosts.add(uri.getHost());
                        switch (applicationType) {
                            case WEB: {
                                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                                    return false;
                                }
                                if (!LOCALHOST.equalsIgnoreCase(uri.getHost())) break;
                                return false;
                            }
                            case NATIVE: {
                                if (!HTTP.equalsIgnoreCase(uri.getScheme())) {
                                    return false;
                                }
                                if (LOCALHOST.equalsIgnoreCase(uri.getHost())) break;
                                return false;
                            }
                        }
                    }
                    break block11;
                }
                return false;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return subjectType == null || !subjectType.equals((Object)SubjectType.PAIRWISE) || !StringUtils.isBlank((String)sectorIdentifierUrl) || redirectUriHosts.size() <= 1;
    }

    public static void validateLogoutUri(String logoutUri, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (Util.isNullOrEmpty((String)logoutUri)) {
            return;
        }
        if (redirectUris == null || redirectUris.isEmpty()) {
            LOG.error((Object)"Preconditions of logout uri validation are failed.", new Object[0]);
            RegisterParamsValidator.throwInvalidLogoutUri(errorResponseFactory);
            return;
        }
        try {
            Set<String> redirectUriHosts = RegisterParamsValidator.collectUriHosts(redirectUris);
            URI uri = new URI(logoutUri);
            if (!redirectUriHosts.contains(uri.getHost())) {
                LOG.error((Object)"logout uri host is not within redirect_uris, logout_uri: {0}, redirect_uris: {1}", new Object[]{logoutUri, redirectUris});
                RegisterParamsValidator.throwInvalidLogoutUri(errorResponseFactory);
                return;
            }
            if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                LOG.error((Object)"logout uri schema is not https, logout_uri: {0}", new Object[]{logoutUri});
                RegisterParamsValidator.throwInvalidLogoutUri(errorResponseFactory);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            RegisterParamsValidator.throwInvalidLogoutUri(errorResponseFactory);
        }
    }

    private static void throwInvalidLogoutUri(ErrorResponseFactory errorResponseFactory) throws WebApplicationException {
        throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_LOGOUT_URI)).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").build());
    }

    private static Set<String> collectUriHosts(List<String> uriList) throws URISyntaxException {
        HashSet<String> hosts = new HashSet<String>();
        for (String redirectUri : uriList) {
            URI uri = new URI(redirectUri);
            hosts.add(uri.getHost());
        }
        return hosts;
    }
}

