/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.config;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.exception.ConfigurationException;
import org.xdi.oxauth.model.config.BaseDnConfiguration;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.StaticConf;
import org.xdi.oxauth.model.error.ErrorMessages;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.util.KeyGenerator;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.properties.FileConfiguration;

@Scope(value=ScopeType.APPLICATION)
@Name(value="configurationFactory")
@AutoCreate
@Startup
public class ConfigurationFactory {
    private static final Log LOG = Logging.getLog(ConfigurationFactory.class);
    public static final String LDAP_CONFIGUARION_RELOAD_EVENT_TYPE = "LDAP_CONFIGUARION_RELOAD";
    private static final String EVENT_TYPE = "ConfigurationFactoryTimerEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final String BASE_DIR = System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String LDAP_FILE_PATH = DIR + "oxauth-ldap.properties";
    @Logger
    private Log log;
    private final String CONFIG_FILE_NAME = "oxauth-config.json";
    private final String ERRORS_FILE_NAME = "oxauth-errors.json";
    private final String STATIC_CONF_FILE_NAME = "oxauth-static-conf.json";
    private final String WEB_KEYS_FILE_NAME = "oxauth-web-keys.json";
    private final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String configFilePath;
    private String errorsFilePath;
    private String staticConfFilePath;
    private String webKeysFilePath;
    private String saltFilePath;
    private FileConfiguration ldapConfiguration;
    private Configuration conf;
    private StaticConf staticConf;
    private JSONWebKeySet jwks;
    private String cryptoConfigurationSalt;
    private AtomicBoolean isActive;
    private long ldapFileLastModifiedTime = -1L;
    private long loadedRevision = -1L;
    private boolean loadedFromLdap = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Create
    public void init() {
        this.isActive = new AtomicBoolean(true);
        try {
            this.loadLdapConfiguration();
            this.confDir = this.confDir();
            this.configFilePath = this.confDir + "oxauth-config.json";
            this.errorsFilePath = this.confDir + "oxauth-errors.json";
            this.staticConfFilePath = this.confDir + "oxauth-static-conf.json";
            this.webKeysFilePath = this.getLdapConfiguration().getString("certsDir") + File.separator + "oxauth-web-keys.json";
            this.saltFilePath = this.confDir + "salt";
            this.loadCryptoConfigurationSalt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void create() {
        if (!this.createFromLdap(true)) {
            LOG.error((Object)"Failed to load configuration from LDAP. Please fix it!!!.", new Object[0]);
            throw new ConfigurationException("Failed to load configuration from LDAP.");
        }
        LOG.info((Object)"Configuration loaded successfully.", new Object[0]);
    }

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void initReloadTimer() {
        long delayBeforeFirstRun = 30000L;
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(30000L), Long.valueOf(30000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"ConfigurationFactoryTimerEvent"})
    @Asynchronous
    public void reloadConfigurationTimerEvent() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error((Object)"Exception happened while reloading application configuration", ex, new Object[0]);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        long lastModified;
        File ldapFile = new File(LDAP_FILE_PATH);
        if (ldapFile.exists() && (lastModified = ldapFile.lastModified()) > this.ldapFileLastModifiedTime) {
            this.loadLdapConfiguration();
            Events.instance().raiseAsynchronousEvent(LDAP_CONFIGUARION_RELOAD_EVENT_TYPE, new Object[0]);
        }
        if (!this.loadedFromLdap) {
            return;
        }
        Conf conf = this.loadConfigurationFromLdap("oxRevision");
        if (conf == null) {
            return;
        }
        if (conf.getRevision() <= this.loadedRevision) {
            return;
        }
        this.createFromLdap(false);
    }

    private String confDir() {
        String confDir = this.getLdapConfiguration().getString("confDir");
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    public FileConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public StaticConf getStaticConfiguration() {
        return this.staticConf;
    }

    public BaseDnConfiguration getBaseDn() {
        return this.getStaticConfiguration().getBaseDn();
    }

    public JSONWebKeySet getWebKeys() {
        return this.jwks;
    }

    public ErrorMessages getErrorResponses() {
        ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
        return f.getMessages();
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    private boolean createFromFile() {
        boolean result = this.reloadConfFromFile() && this.reloadErrorsFromFile() && this.reloadStaticConfFromFile() && this.reloadWebkeyFromFile();
        return result;
    }

    private boolean reloadWebkeyFromFile() {
        JSONWebKeySet webKeysFromFile = this.loadWebKeysFromFile();
        if (webKeysFromFile != null) {
            LOG.info((Object)("Reloaded web keys from file: " + this.webKeysFilePath), new Object[0]);
            this.jwks = webKeysFromFile;
            return true;
        }
        LOG.error((Object)("Failed to load web keys configuration from file: " + this.webKeysFilePath), new Object[0]);
        return false;
    }

    private boolean reloadStaticConfFromFile() {
        StaticConf staticConfFromFile = this.loadStaticConfFromFile();
        if (staticConfFromFile != null) {
            LOG.info((Object)("Reloaded static conf from file: " + this.staticConfFilePath), new Object[0]);
            this.staticConf = staticConfFromFile;
            return true;
        }
        LOG.error((Object)("Failed to load static configuration from file: " + this.staticConfFilePath), new Object[0]);
        return false;
    }

    private boolean reloadErrorsFromFile() {
        ErrorMessages errorsFromFile = this.loadErrorsFromFile();
        if (errorsFromFile != null) {
            LOG.info((Object)("Reloaded errors from file: " + this.errorsFilePath), new Object[0]);
            ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
            f.setMessages(errorsFromFile);
            return true;
        }
        LOG.error((Object)("Failed to load errors from file: " + this.errorsFilePath), new Object[0]);
        return false;
    }

    private boolean reloadConfFromFile() {
        Configuration configFromFile = this.loadConfFromFile();
        if (configFromFile != null) {
            LOG.info((Object)("Reloaded configuration from file: " + this.configFilePath), new Object[0]);
            this.conf = configFromFile;
            return true;
        }
        LOG.error((Object)("Failed to load configuration from file: " + this.configFilePath), new Object[0]);
        return false;
    }

    private boolean createFromLdap(boolean recoverFromFiles) {
        LOG.info((Object)"Loading configuration from LDAP...", new Object[0]);
        try {
            Conf conf = this.loadConfigurationFromLdap(new String[0]);
            if (conf != null) {
                this.init(conf);
                return true;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        if (recoverFromFiles) {
            LOG.info((Object)"Unable to find configuration in LDAP, try to load configuration from file system... ", new Object[0]);
            if (this.createFromFile()) {
                this.loadedFromLdap = false;
                return true;
            }
        }
        return false;
    }

    private Conf loadConfigurationFromLdap(String ... returnAttributes) {
        LdapEntryManager ldapManager = ServerUtil.getLdapManager();
        String dn = this.getLdapConfiguration().getString("configurationEntryDN");
        try {
            Conf conf = (Conf)ldapManager.find(Conf.class, (Object)dn, returnAttributes);
            return conf;
        }
        catch (LdapMappingException ex) {
            LOG.error((Object)ex.getMessage(), new Object[0]);
            return null;
        }
    }

    private void init(Conf p_conf) {
        this.initConfigurationFromJson(p_conf.getDynamic());
        this.initStaticConfigurationFromJson(p_conf.getStatics());
        this.initErrorsFromJson(p_conf.getErrors());
        this.initWebKeysFromJson(p_conf.getWebKeys());
        this.loadedRevision = p_conf.getRevision();
    }

    private void initWebKeysFromJson(String p_webKeys) {
        try {
            this.initJwksFromString(p_webKeys);
        }
        catch (JsonParseException ex) {
            this.log.error((Object)"Failed to load JWKS. Attempting to generate new JWKS...", (Throwable)ex, new Object[0]);
            String newWebKeys = null;
            try {
                newWebKeys = KeyGenerator.generateJWKS().toString();
                this.initJwksFromString(newWebKeys);
                Conf conf = this.loadConfigurationFromLdap(new String[0]);
                conf.setWebKeys(newWebKeys);
                long nextRevision = conf.getRevision() + 1L;
                conf.setRevision(nextRevision);
                LdapEntryManager ldapManager = ServerUtil.getLdapManager();
                ldapManager.merge((Object)conf);
                this.log.info((Object)"New JWKS generated successfully", new Object[0]);
            }
            catch (Exception ex2) {
                this.log.error((Object)"Failed to re-generate JWKS keys", (Throwable)ex2, new Object[0]);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    public void initJwksFromString(String p_webKeys) throws IOException, JsonParseException, JsonMappingException {
        JSONWebKeySet k = (JSONWebKeySet)ServerUtil.createJsonMapper().readValue(p_webKeys, JSONWebKeySet.class);
        if (k != null) {
            this.jwks = k;
        }
    }

    private void initStaticConfigurationFromJson(String p_statics) {
        try {
            StaticConf c = (StaticConf)ServerUtil.createJsonMapper().readValue(p_statics, StaticConf.class);
            if (c != null) {
                this.staticConf = c;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void initConfigurationFromJson(String p_configurationJson) {
        try {
            Configuration c = (Configuration)ServerUtil.createJsonMapper().readValue(p_configurationJson, Configuration.class);
            if (c != null) {
                this.conf = c;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void initErrorsFromJson(String p_errosAsJson) {
        try {
            ErrorMessages errorMessages = (ErrorMessages)ServerUtil.createJsonMapper().readValue(p_errosAsJson, ErrorMessages.class);
            if (errorMessages != null) {
                ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
                f.setMessages(errorMessages);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void loadLdapConfiguration() {
        try {
            this.ldapConfiguration = new FileConfiguration(LDAP_FILE_PATH);
            File ldapFile = new File(LDAP_FILE_PATH);
            if (ldapFile.exists()) {
                this.ldapFileLastModifiedTime = ldapFile.lastModified();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            this.ldapConfiguration = null;
        }
    }

    private Configuration loadConfFromFile() {
        try {
            return (Configuration)ServerUtil.createJsonMapper().readValue(new File(this.configFilePath), Configuration.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private ErrorMessages loadErrorsFromFile() {
        try {
            return (ErrorMessages)ServerUtil.createJsonMapper().readValue(new File(this.errorsFilePath), ErrorMessages.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private StaticConf loadStaticConfFromFile() {
        try {
            return (StaticConf)ServerUtil.createJsonMapper().readValue(new File(this.staticConfFilePath), StaticConf.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private JSONWebKeySet loadWebKeysFromFile() {
        try {
            return (JSONWebKeySet)ServerUtil.createJsonMapper().readValue(new File(this.webKeysFilePath), JSONWebKeySet.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to load configuration from {0}", (Throwable)ex, new Object[]{this.saltFilePath});
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                LOG.error((Object)"Failed to load configuration from {0}", (Throwable)ex, new Object[]{fileName});
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    public static ConfigurationFactory instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (ConfigurationFactory)Component.getInstance(ConfigurationFactory.class);
    }
}

