/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import org.apache.commons.lang.StringUtils;

public enum Mode {
    IN_MEMORY("memory"),
    LDAP("ldap");

    public static final Mode DEFAULT;
    private final String m_value;

    private Mode(String p_value) {
        this.m_value = p_value;
    }

    public String getValue() {
        return this.m_value;
    }

    public static Mode fromValue(String p_value) {
        if (StringUtils.isNotBlank((String)p_value)) {
            for (Mode m : Mode.values()) {
                if (!m.getValue().equals(p_value)) continue;
                return m;
            }
        }
        return null;
    }

    public static Mode fromValueWithDefault(String p_value) {
        Mode result = Mode.fromValue(p_value);
        return result != null ? result : DEFAULT;
    }

    static {
        DEFAULT = IN_MEMORY;
    }
}

