/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.security.SignatureException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AbstractAuthorizationGrant;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrantInMemory;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.ldap.TokenType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.GrantService;
import org.xdi.util.security.StringEncrypter;

public class AuthorizationGrantLdap
extends AbstractAuthorizationGrant {
    private static final Logger LOGGER = Logger.getLogger(AuthorizationGrantLdap.class);
    private static final int THREADS_COUNT = 200;
    private final GrantService m_grantService = GrantService.instance();

    public AuthorizationGrantLdap(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super(user, authorizationGrantType, client, authenticationTime);
    }

    @Override
    public String checkScopesPolicy(String scope) {
        String result = super.checkScopesPolicy(scope);
        this.save();
        return result;
    }

    @Override
    public void save() {
        this.saveImpl();
    }

    private void saveImpl() {
        List<TokenLdap> grants;
        String grantId = this.getGrantId();
        if (grantId != null && StringUtils.isNotBlank((String)grantId) && (grants = this.m_grantService.getGrantsByGrantId(grantId)) != null && !grants.isEmpty()) {
            String nonce = this.getNonce();
            String scopes = this.getScopesAsString();
            for (TokenLdap t : grants) {
                t.setNonce(nonce);
                t.setScope(scopes);
                t.setAuthMode(this.getAcrValues());
                t.setAuthenticationTime(this.getAuthenticationTime() != null ? this.getAuthenticationTime().toString() : "");
                JwtAuthorizationRequest jwtRequest = this.getJwtAuthorizationRequest();
                if (jwtRequest != null && StringUtils.isNotBlank((String)jwtRequest.getEncodedJwt())) {
                    t.setJwtRequest(jwtRequest.getEncodedJwt());
                }
                this.m_grantService.mergeSilently(t);
            }
        }
    }

    @Override
    public AccessToken createAccessToken() {
        try {
            AccessToken accessToken = super.createAccessToken();
            if (accessToken.getExpiresIn() > 0) {
                this.persist(this.asToken(accessToken));
            }
            return accessToken;
        }
        catch (Exception e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public AccessToken createLongLivedAccessToken() {
        try {
            AccessToken accessToken = super.createLongLivedAccessToken();
            if (accessToken.getExpiresIn() > 0) {
                this.persist(this.asToken(accessToken));
            }
            return accessToken;
        }
        catch (Exception e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public RefreshToken createRefreshToken() {
        try {
            RefreshToken refreshToken = super.createRefreshToken();
            if (refreshToken.getExpiresIn() > 0) {
                this.persist(this.asToken(refreshToken));
            }
            return refreshToken;
        }
        catch (Exception e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IdToken createIdToken(String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, String authMode) throws SignatureException, StringEncrypter.EncryptionException, InvalidJwtException, InvalidJweException {
        try {
            IdToken idToken = AuthorizationGrantInMemory.createIdToken(this, nonce, authorizationCode, accessToken, this.getScopes());
            if (idToken.getExpiresIn() > 0) {
                TokenLdap tokenLdap = this.asToken(idToken);
                tokenLdap.setAuthMode(authMode);
                this.persist(tokenLdap);
            }
            this.setAcrValues(authMode);
            this.save();
            return idToken;
        }
        catch (Exception e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void persist(TokenLdap p_token) {
        this.m_grantService.persist(p_token);
    }

    public void persist(AuthorizationCode p_code) {
        this.persist(this.asToken(p_code));
    }

    public TokenLdap asToken(IdToken p_token) {
        TokenLdap result = this.asTokenLdap(p_token);
        result.setTokenTypeEnum(TokenType.ID_TOKEN);
        return result;
    }

    public TokenLdap asToken(RefreshToken p_token) {
        TokenLdap result = this.asTokenLdap(p_token);
        result.setTokenTypeEnum(TokenType.REFRESH_TOKEN);
        return result;
    }

    public TokenLdap asToken(AuthorizationCode p_authorizationCode) {
        TokenLdap result = this.asTokenLdap(p_authorizationCode);
        result.setTokenTypeEnum(TokenType.AUTHORIZATION_CODE);
        return result;
    }

    public TokenLdap asToken(AccessToken p_accessToken) {
        TokenLdap result = this.asTokenLdap(p_accessToken);
        result.setTokenTypeEnum(TokenType.ACCESS_TOKEN);
        return result;
    }

    public String getScopesAsString() {
        StringBuilder scopes = new StringBuilder();
        for (String s : this.getScopes()) {
            scopes.append(s).append(" ");
        }
        return scopes.toString().trim();
    }

    public TokenLdap asTokenLdap(AbstractToken p_token) {
        JwtAuthorizationRequest jwtRequest;
        String nonce;
        AuthorizationCode authorizationCode;
        String id = GrantService.generateGrantId();
        TokenLdap result = new TokenLdap();
        result.setDn(GrantService.buildDn(id, this.getGrantId(), this.getClientId()));
        result.setId(id);
        result.setGrantId(this.getGrantId());
        result.setCreationDate(p_token.getCreationDate());
        result.setExpirationDate(p_token.getExpirationDate());
        result.setTokenCode(p_token.getCode());
        result.setUserId(this.getUserId());
        result.setClientId(this.getClientId());
        result.setScope(this.getScopesAsString());
        result.setAuthMode(p_token.getAuthMode());
        result.setAuthenticationTime(this.getAuthenticationTime() != null ? this.getAuthenticationTime().toString() : "");
        AuthorizationGrantType grantType = this.getAuthorizationGrantType();
        if (grantType != null) {
            result.setGrantType(grantType.getParamName());
        }
        if ((authorizationCode = this.getAuthorizationCode()) != null) {
            result.setAuthorizationCode(authorizationCode.getCode());
        }
        if ((nonce = this.getNonce()) != null) {
            result.setNonce(nonce);
        }
        if ((jwtRequest = this.getJwtAuthorizationRequest()) != null && StringUtils.isNotBlank((String)jwtRequest.getEncodedJwt())) {
            result.setJwtRequest(jwtRequest.getEncodedJwt());
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void revokeAllTokens() {
        TokenLdap tokenLdap = this.getTokenLdap();
        if (tokenLdap != null && StringUtils.isNotBlank((String)tokenLdap.getGrantId())) {
            this.m_grantService.removeAllByGrantId(tokenLdap.getGrantId());
        }
    }

    @Override
    public void checkExpiredTokens() {
    }
}

