/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.authorize.ScopeChecker;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.registration.Client;

public abstract class AbstractAuthorizationGrant
implements IAuthorizationGrant {
    private static final Logger LOGGER = Logger.getLogger(AbstractAuthorizationGrant.class);
    private final User user;
    private final AuthorizationGrantType authorizationGrantType;
    private final Client client;
    private final Set<String> scopes;
    private String grantId;
    private JwtAuthorizationRequest jwtAuthorizationRequest;
    private Date authenticationTime;
    private TokenLdap tokenLdap;
    private AccessToken longLivedAccessToken;
    private IdToken idToken;
    private AuthorizationCode authorizationCode;
    private String nonce;
    private String acrValues;
    protected final ConcurrentMap<String, AccessToken> accessTokens = new ConcurrentHashMap<String, AccessToken>();
    protected final ConcurrentMap<String, RefreshToken> refreshTokens = new ConcurrentHashMap<String, RefreshToken>();

    protected AbstractAuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
        this.user = user;
        this.authorizationGrantType = authorizationGrantType;
        this.client = client;
        this.scopes = new CopyOnWriteArraySet<String>();
        this.grantId = UUID.randomUUID().toString();
    }

    @Override
    public synchronized String getGrantId() {
        return this.grantId;
    }

    @Override
    public synchronized void setGrantId(String p_grantId) {
        this.grantId = p_grantId;
    }

    @Override
    public AuthorizationCode getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    public void setAuthorizationCode(AuthorizationCode authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @Override
    public Set<String> getRefreshTokensCodes() {
        return this.refreshTokens.keySet();
    }

    @Override
    public Set<String> getAccessTokensCodes() {
        return this.accessTokens.keySet();
    }

    @Override
    public List<AccessToken> getAccessTokens() {
        return new ArrayList<AccessToken>(this.accessTokens.values());
    }

    @Override
    public void setScopes(Collection<String> scopes) {
        this.scopes.clear();
        this.scopes.addAll(scopes);
    }

    @Override
    public AccessToken getLongLivedAccessToken() {
        return this.longLivedAccessToken;
    }

    @Override
    public void setLongLivedAccessToken(AccessToken longLivedAccessToken) {
        this.longLivedAccessToken = longLivedAccessToken;
    }

    @Override
    public IdToken getIdToken() {
        return this.idToken;
    }

    @Override
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    @Override
    public TokenLdap getTokenLdap() {
        return this.tokenLdap;
    }

    @Override
    public void setTokenLdap(TokenLdap p_tokenLdap) {
        this.tokenLdap = p_tokenLdap;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getAcrValues() {
        return this.acrValues;
    }

    @Override
    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    @Override
    public String checkScopesPolicy(String requestedScopes) {
        this.scopes.clear();
        Set<String> grantedScopes = ScopeChecker.instance().checkScopesPolicy(this.client, requestedScopes);
        this.scopes.addAll(grantedScopes);
        StringBuilder grantedScopesSb = new StringBuilder();
        for (String scope : this.scopes) {
            grantedScopesSb.append(" ").append(scope);
        }
        String grantedScopesSt = grantedScopesSb.toString().trim();
        return grantedScopesSt;
    }

    @Override
    public AccessToken createAccessToken() {
        int lifetime = ConfigurationFactory.instance().getConfiguration().getShortLivedAccessTokenLifetime();
        AccessToken accessToken = new AccessToken(lifetime);
        accessToken.setAuthMode(this.getAcrValues());
        return accessToken;
    }

    @Override
    public AccessToken createLongLivedAccessToken() {
        int lifetime = ConfigurationFactory.instance().getConfiguration().getLongLivedAccessTokenLifetime();
        AccessToken accessToken = new AccessToken(lifetime);
        accessToken.setAuthMode(this.getAcrValues());
        return accessToken;
    }

    @Override
    public RefreshToken createRefreshToken() {
        int lifetime = ConfigurationFactory.instance().getConfiguration().getRefreshTokenLifetime();
        RefreshToken refreshToken = new RefreshToken(lifetime);
        refreshToken.setAuthMode(this.getAcrValues());
        return refreshToken;
    }

    @Override
    public String getUserId() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUserId();
    }

    @Override
    public String getUserDn() {
        if (this.user == null) {
            return null;
        }
        return this.user.getDn();
    }

    @Override
    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public String getClientId() {
        if (this.client == null) {
            return null;
        }
        return this.client.getClientId();
    }

    @Override
    public String getClientDn() {
        if (this.client == null) {
            return null;
        }
        return this.client.getDn();
    }

    @Override
    public Date getAuthenticationTime() {
        return this.authenticationTime != null ? new Date(this.authenticationTime.getTime()) : null;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
    }

    @Override
    public Set<String> getScopes() {
        return this.scopes;
    }

    @Override
    public JwtAuthorizationRequest getJwtAuthorizationRequest() {
        return this.jwtAuthorizationRequest;
    }

    @Override
    public void setJwtAuthorizationRequest(JwtAuthorizationRequest p_jwtAuthorizationRequest) {
        this.jwtAuthorizationRequest = p_jwtAuthorizationRequest;
    }

    @Override
    public void setAccessTokens(List<AccessToken> accessTokens) {
        AbstractAuthorizationGrant.put(this.accessTokens, accessTokens);
    }

    private static <T extends AbstractToken> void put(ConcurrentMap<String, T> p_map, List<T> p_list) {
        p_map.clear();
        if (p_list != null && !p_list.isEmpty()) {
            for (AbstractToken t : p_list) {
                p_map.put(t.getCode(), t);
            }
        }
    }

    @Override
    public List<RefreshToken> getRefreshTokens() {
        return new ArrayList<RefreshToken>(this.refreshTokens.values());
    }

    @Override
    public void setRefreshTokens(List<RefreshToken> refreshTokens) {
        AbstractAuthorizationGrant.put(this.refreshTokens, refreshTokens);
    }

    @Override
    public RefreshToken getRefreshToken(String refreshTokenCode) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Looking for the refresh token: " + refreshTokenCode + " for an authorization grant of type: " + (Object)((Object)this.getAuthorizationGrantType())));
        }
        return (RefreshToken)this.refreshTokens.get(refreshTokenCode);
    }

    @Override
    public AbstractToken getAccessToken(String tokenCode) {
        IdToken idToken = this.getIdToken();
        if (idToken != null && idToken.getCode().equals(tokenCode)) {
            return idToken;
        }
        AccessToken longLivedAccessToken = this.getLongLivedAccessToken();
        if (longLivedAccessToken != null && longLivedAccessToken.getCode().equals(tokenCode)) {
            return longLivedAccessToken;
        }
        return (AbstractToken)this.accessTokens.get(tokenCode);
    }
}

