/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.authorize;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.ScopeService;

@org.jboss.seam.annotations.Scope(value=ScopeType.STATELESS)
@Name(value="scopeChecker")
@AutoCreate
public class ScopeChecker {
    @Logger
    private Log log;

    public Set<String> checkScopesPolicy(Client client, String scope) {
        this.log.debug((Object)("Checking scopes policy for: " + scope), new Object[0]);
        HashSet<String> grantedScopes = new HashSet<String>();
        ScopeService scopeService = ScopeService.instance();
        String[] scopesRequested = scope.split(" ");
        String[] scopesAllowed = client.getScopes();
        if (ConfigurationFactory.instance().getConfiguration().getFederationEnabled().booleanValue()) {
            this.log.trace((Object)"Ignore client scopes because federation is enabled (take scopes from trust).", new Object[0]);
            List<FederationTrust> list = FederationDataService.instance().getTrustByClient(client, FederationTrustStatus.ACTIVE);
            List<String> allScopes = FederationDataService.getScopes(list);
            this.log.trace((Object)("Take scopes from federation trust list: " + list), new Object[0]);
            for (String dn : allScopes) {
                Scope scopeByDn = scopeService.getScopeByDnSilently(dn);
                if (scopeByDn == null) continue;
                String displayName = scopeByDn.getDisplayName();
                grantedScopes.add(displayName);
            }
        } else {
            for (String scopeRequested : scopesRequested) {
                if (!StringUtils.isNotBlank((String)scopeRequested)) continue;
                for (String scopeAllowedDn : scopesAllowed) {
                    String scopeAllowedName;
                    Scope scopeAllowed = scopeService.getScopeByDnSilently(scopeAllowedDn);
                    if (scopeAllowed == null || !scopeRequested.equals(scopeAllowedName = scopeAllowed.getDisplayName())) continue;
                    grantedScopes.add(scopeRequested);
                }
            }
        }
        this.log.debug((Object)("Granted scopes: " + grantedScopes), new Object[0]);
        return grantedScopes;
    }

    public static ScopeChecker instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (ScopeChecker)Component.getInstance(ScopeChecker.class);
    }
}

